exports.ids = [66,3,7,12,21,29,34];
exports.modules = {

/***/ 111:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _VIcon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(113);


/* harmony default export */ __webpack_exports__["a"] = (_VIcon__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"]);

/***/ }),

/***/ 113:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _src_components_VIcon_VIcon_sass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(116);
/* harmony import */ var _src_components_VIcon_VIcon_sass__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_src_components_VIcon_VIcon_sass__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mixins_binds_attrs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _mixins_colorable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _mixins_sizeable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48);
/* harmony import */ var _mixins_themeable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
/* harmony import */ var _util_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(0);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(vue__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _util_mixins__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6);
 // Mixins




 // Util

 // Types



var SIZE_MAP;
(function (SIZE_MAP) {
  SIZE_MAP["xSmall"] = "12px";
  SIZE_MAP["small"] = "16px";
  SIZE_MAP["default"] = "24px";
  SIZE_MAP["medium"] = "28px";
  SIZE_MAP["large"] = "36px";
  SIZE_MAP["xLarge"] = "40px";
})(SIZE_MAP || (SIZE_MAP = {}));
function isFontAwesome5(iconType) {
  return ['fas', 'far', 'fal', 'fab', 'fad', 'fak'].some(val => iconType.includes(val));
}
function isSvgPath(icon) {
  return /^[mzlhvcsqta]\s*[-+.0-9][^mlhvzcsqta]+/i.test(icon) && /[\dz]$/i.test(icon) && icon.length > 4;
}
const VIcon = Object(_util_mixins__WEBPACK_IMPORTED_MODULE_7__[/* default */ "a"])(_mixins_binds_attrs__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"], _mixins_colorable__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], _mixins_sizeable__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"], _mixins_themeable__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"]
/* @vue/component */).extend({
  name: 'v-icon',
  props: {
    dense: Boolean,
    disabled: Boolean,
    left: Boolean,
    right: Boolean,
    size: [Number, String],
    tag: {
      type: String,
      required: false,
      default: 'i'
    }
  },
  computed: {
    medium() {
      return false;
    },
    hasClickListener() {
      return Boolean(this.listeners$.click || this.listeners$['!click']);
    }
  },
  methods: {
    getIcon() {
      let iconName = '';
      if (this.$slots.default) iconName = this.$slots.default[0].text.trim();
      return Object(_util_helpers__WEBPACK_IMPORTED_MODULE_5__[/* remapInternalIcon */ "w"])(this, iconName);
    },
    getSize() {
      const sizes = {
        xSmall: this.xSmall,
        small: this.small,
        medium: this.medium,
        large: this.large,
        xLarge: this.xLarge
      };
      const explicitSize = Object(_util_helpers__WEBPACK_IMPORTED_MODULE_5__[/* keys */ "t"])(sizes).find(key => sizes[key]);
      return explicitSize && SIZE_MAP[explicitSize] || Object(_util_helpers__WEBPACK_IMPORTED_MODULE_5__[/* convertToUnit */ "g"])(this.size);
    },
    // Component data for both font icon and SVG wrapper span
    getDefaultData() {
      return {
        staticClass: 'v-icon notranslate',
        class: {
          'v-icon--disabled': this.disabled,
          'v-icon--left': this.left,
          'v-icon--link': this.hasClickListener,
          'v-icon--right': this.right,
          'v-icon--dense': this.dense
        },
        attrs: {
          'aria-hidden': !this.hasClickListener,
          disabled: this.hasClickListener && this.disabled,
          type: this.hasClickListener ? 'button' : undefined,
          ...this.attrs$
        },
        on: this.listeners$
      };
    },
    getSvgWrapperData() {
      const fontSize = this.getSize();
      const wrapperData = {
        ...this.getDefaultData(),
        style: fontSize ? {
          fontSize,
          height: fontSize,
          width: fontSize
        } : undefined
      };
      this.applyColors(wrapperData);
      return wrapperData;
    },
    applyColors(data) {
      data.class = {
        ...data.class,
        ...this.themeClasses
      };
      this.setTextColor(this.color, data);
    },
    renderFontIcon(icon, h) {
      const newChildren = [];
      const data = this.getDefaultData();
      let iconType = 'material-icons'; // Material Icon delimiter is _
      // https://material.io/icons/

      const delimiterIndex = icon.indexOf('-');
      const isMaterialIcon = delimiterIndex <= -1;
      if (isMaterialIcon) {
        // Material icon uses ligatures.
        newChildren.push(icon);
      } else {
        iconType = icon.slice(0, delimiterIndex);
        if (isFontAwesome5(iconType)) iconType = '';
      }
      data.class[iconType] = true;
      data.class[icon] = !isMaterialIcon;
      const fontSize = this.getSize();
      if (fontSize) data.style = {
        fontSize
      };
      this.applyColors(data);
      return h(this.hasClickListener ? 'button' : this.tag, data, newChildren);
    },
    renderSvgIcon(icon, h) {
      const svgData = {
        class: 'v-icon__svg',
        attrs: {
          xmlns: 'http://www.w3.org/2000/svg',
          viewBox: '0 0 24 24',
          role: 'img',
          'aria-hidden': true
        }
      };
      const size = this.getSize();
      if (size) {
        svgData.style = {
          fontSize: size,
          height: size,
          width: size
        };
      }
      return h(this.hasClickListener ? 'button' : 'span', this.getSvgWrapperData(), [h('svg', svgData, [h('path', {
        attrs: {
          d: icon
        }
      })])]);
    },
    renderSvgIconComponent(icon, h) {
      const data = {
        class: {
          'v-icon__component': true
        }
      };
      const size = this.getSize();
      if (size) {
        data.style = {
          fontSize: size,
          height: size,
          width: size
        };
      }
      this.applyColors(data);
      const component = icon.component;
      data.props = icon.props;
      data.nativeOn = data.on;
      return h(this.hasClickListener ? 'button' : 'span', this.getSvgWrapperData(), [h(component, data)]);
    }
  },
  render(h) {
    const icon = this.getIcon();
    if (typeof icon === 'string') {
      if (isSvgPath(icon)) {
        return this.renderSvgIcon(icon, h);
      }
      return this.renderFontIcon(icon, h);
    }
    return this.renderSvgIconComponent(icon, h);
  }
});
/* harmony default export */ __webpack_exports__["a"] = (vue__WEBPACK_IMPORTED_MODULE_6___default.a.extend({
  name: 'v-icon',
  $_wrapperFor: VIcon,
  functional: true,
  render(h, {
    data,
    children
  }) {
    let iconName = ''; // Support usage of v-text and v-html

    if (data.domProps) {
      iconName = data.domProps.textContent || data.domProps.innerHTML || iconName; // Remove nodes so it doesn't
      // overwrite our changes

      delete data.domProps.textContent;
      delete data.domProps.innerHTML;
    }
    return h(VIcon, data, iconName ? [iconName] : children);
  }
}));

/***/ }),

/***/ 114:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// UNUSED EXPORTS: VInput

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VInput/VInput.sass
var VInput = __webpack_require__(127);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VIcon/index.js
var VIcon = __webpack_require__(111);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VLabel/index.js + 1 modules
var VLabel = __webpack_require__(115);

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VMessages/VMessages.sass
var VMessages = __webpack_require__(129);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/colorable/index.js
var colorable = __webpack_require__(13);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/themeable/index.js
var themeable = __webpack_require__(12);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mixins.js
var mixins = __webpack_require__(6);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/helpers.js
var helpers = __webpack_require__(2);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VMessages/VMessages.js
// Styles
 // Mixins



 // Utilities


/* @vue/component */

/* harmony default export */ var VMessages_VMessages = (Object(mixins["a" /* default */])(colorable["a" /* default */], themeable["a" /* default */]).extend({
  name: 'v-messages',
  props: {
    value: {
      type: Array,
      default: () => []
    }
  },
  methods: {
    genChildren() {
      return this.$createElement('transition-group', {
        staticClass: 'v-messages__wrapper',
        attrs: {
          name: 'message-transition',
          tag: 'div'
        }
      }, this.value.map(this.genMessage));
    },
    genMessage(message, key) {
      return this.$createElement('div', {
        staticClass: 'v-messages__message',
        key
      }, Object(helpers["o" /* getSlot */])(this, 'default', {
        message,
        key
      }) || [message]);
    }
  },
  render(h) {
    return h('div', this.setTextColor(this.color, {
      staticClass: 'v-messages',
      class: this.themeClasses
    }), [this.genChildren()]);
  }
}));
// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VMessages/index.js


/* harmony default export */ var components_VMessages = (VMessages_VMessages);
// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/binds-attrs/index.js
var binds_attrs = __webpack_require__(44);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/validatable/index.js
var validatable = __webpack_require__(118);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mergeData.js
var mergeData = __webpack_require__(8);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VInput/VInput.js
// Styles
 // Components



 // Mixins


 // Utilities




const baseMixins = Object(mixins["a" /* default */])(binds_attrs["a" /* default */], validatable["a" /* default */]);
/* @vue/component */

/* harmony default export */ var VInput_VInput = (baseMixins.extend().extend({
  name: 'v-input',
  inheritAttrs: false,
  props: {
    appendIcon: String,
    backgroundColor: {
      type: String,
      default: ''
    },
    dense: Boolean,
    height: [Number, String],
    hideDetails: [Boolean, String],
    hideSpinButtons: Boolean,
    hint: String,
    id: String,
    label: String,
    loading: Boolean,
    persistentHint: Boolean,
    prependIcon: String,
    value: null
  },
  data() {
    return {
      lazyValue: this.value,
      hasMouseDown: false
    };
  },
  computed: {
    classes() {
      return {
        'v-input--has-state': this.hasState,
        'v-input--hide-details': !this.showDetails,
        'v-input--is-label-active': this.isLabelActive,
        'v-input--is-dirty': this.isDirty,
        'v-input--is-disabled': this.isDisabled,
        'v-input--is-focused': this.isFocused,
        // <v-switch loading>.loading === '' so we can't just cast to boolean
        'v-input--is-loading': this.loading !== false && this.loading != null,
        'v-input--is-readonly': this.isReadonly,
        'v-input--dense': this.dense,
        'v-input--hide-spin-buttons': this.hideSpinButtons,
        ...this.themeClasses
      };
    },
    computedId() {
      return this.id || `input-${this._uid}`;
    },
    hasDetails() {
      return this.messagesToDisplay.length > 0;
    },
    hasHint() {
      return !this.hasMessages && !!this.hint && (this.persistentHint || this.isFocused);
    },
    hasLabel() {
      return !!(this.$slots.label || this.label);
    },
    // Proxy for `lazyValue`
    // This allows an input
    // to function without
    // a provided model
    internalValue: {
      get() {
        return this.lazyValue;
      },
      set(val) {
        this.lazyValue = val;
        this.$emit(this.$_modelEvent, val);
      }
    },
    isDirty() {
      return !!this.lazyValue;
    },
    isLabelActive() {
      return this.isDirty;
    },
    messagesToDisplay() {
      if (this.hasHint) return [this.hint];
      if (!this.hasMessages) return [];
      return this.validations.map(validation => {
        if (typeof validation === 'string') return validation;
        const validationResult = validation(this.internalValue);
        return typeof validationResult === 'string' ? validationResult : '';
      }).filter(message => message !== '');
    },
    showDetails() {
      return this.hideDetails === false || this.hideDetails === 'auto' && this.hasDetails;
    }
  },
  watch: {
    value(val) {
      this.lazyValue = val;
    }
  },
  beforeCreate() {
    // v-radio-group needs to emit a different event
    // https://github.com/vuetifyjs/vuetify/issues/4752
    this.$_modelEvent = this.$options.model && this.$options.model.event || 'input';
  },
  methods: {
    genContent() {
      return [this.genPrependSlot(), this.genControl(), this.genAppendSlot()];
    },
    genControl() {
      return this.$createElement('div', {
        staticClass: 'v-input__control',
        attrs: {
          title: this.attrs$.title
        }
      }, [this.genInputSlot(), this.genMessages()]);
    },
    genDefaultSlot() {
      return [this.genLabel(), this.$slots.default];
    },
    genIcon(type, cb, extraData = {}) {
      var _a;
      const icon = this[`${type}Icon`];
      const eventName = `click:${Object(helpers["r" /* kebabCase */])(type)}`;
      const hasListener = !!(this.listeners$[eventName] || cb);
      const localeKey = {
        prepend: 'prependAction',
        prependInner: 'prependAction',
        append: 'appendAction',
        appendOuter: 'appendAction',
        clear: 'clear'
      }[type];
      const label = hasListener && localeKey ? this.$vuetify.lang.t(`$vuetify.input.${localeKey}`, (_a = this.label) !== null && _a !== void 0 ? _a : '') : undefined;
      const data = Object(mergeData["a" /* default */])({
        attrs: {
          'aria-label': label,
          color: this.validationState,
          dark: this.dark,
          disabled: this.isDisabled,
          light: this.light,
          tabindex: type === 'clear' ? -1 : undefined
        },
        on: !hasListener ? undefined : {
          click: e => {
            e.preventDefault();
            e.stopPropagation();
            this.$emit(eventName, e);
            cb && cb(e);
          },
          // Container has g event that will
          // trigger menu open if enclosed
          mouseup: e => {
            e.preventDefault();
            e.stopPropagation();
          }
        }
      }, extraData);
      return this.$createElement('div', {
        staticClass: `v-input__icon`,
        class: type ? `v-input__icon--${Object(helpers["r" /* kebabCase */])(type)}` : undefined
      }, [this.$createElement(VIcon["a" /* default */], data, icon)]);
    },
    genInputSlot() {
      return this.$createElement('div', this.setBackgroundColor(this.backgroundColor, {
        staticClass: 'v-input__slot',
        style: {
          height: Object(helpers["g" /* convertToUnit */])(this.height)
        },
        on: {
          click: this.onClick,
          mousedown: this.onMouseDown,
          mouseup: this.onMouseUp
        },
        ref: 'input-slot'
      }), [this.genDefaultSlot()]);
    },
    genLabel() {
      if (!this.hasLabel) return null;
      return this.$createElement(VLabel["a" /* default */], {
        props: {
          color: this.validationState,
          dark: this.dark,
          disabled: this.isDisabled,
          focused: this.hasState,
          for: this.computedId,
          light: this.light
        }
      }, this.$slots.label || this.label);
    },
    genMessages() {
      if (!this.showDetails) return null;
      return this.$createElement(components_VMessages, {
        props: {
          color: this.hasHint ? '' : this.validationState,
          dark: this.dark,
          light: this.light,
          value: this.messagesToDisplay
        },
        attrs: {
          role: this.hasMessages ? 'alert' : null
        },
        scopedSlots: {
          default: props => Object(helpers["o" /* getSlot */])(this, 'message', props)
        }
      });
    },
    genSlot(type, location, slot) {
      if (!slot.length) return null;
      const ref = `${type}-${location}`;
      return this.$createElement('div', {
        staticClass: `v-input__${ref}`,
        ref
      }, slot);
    },
    genPrependSlot() {
      const slot = [];
      if (this.$slots.prepend) {
        slot.push(this.$slots.prepend);
      } else if (this.prependIcon) {
        slot.push(this.genIcon('prepend'));
      }
      return this.genSlot('prepend', 'outer', slot);
    },
    genAppendSlot() {
      const slot = []; // Append icon for text field was really
      // an appended inner icon, v-text-field
      // will overwrite this method in order to obtain
      // backwards compat

      if (this.$slots.append) {
        slot.push(this.$slots.append);
      } else if (this.appendIcon) {
        slot.push(this.genIcon('append'));
      }
      return this.genSlot('append', 'outer', slot);
    },
    onClick(e) {
      this.$emit('click', e);
    },
    onMouseDown(e) {
      this.hasMouseDown = true;
      this.$emit('mousedown', e);
    },
    onMouseUp(e) {
      this.hasMouseDown = false;
      this.$emit('mouseup', e);
    }
  },
  render(h) {
    return h('div', this.setTextColor(this.validationState, {
      staticClass: 'v-input',
      class: this.classes
    }), this.genContent());
  }
}));
// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VInput/index.js


/* harmony default export */ var components_VInput = __webpack_exports__["a"] = (VInput_VInput);

/***/ }),

/***/ 115:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// UNUSED EXPORTS: VLabel

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VLabel/VLabel.sass
var VLabel = __webpack_require__(128);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/colorable/index.js
var colorable = __webpack_require__(13);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/themeable/index.js
var themeable = __webpack_require__(12);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mixins.js
var mixins = __webpack_require__(6);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/helpers.js
var helpers = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mergeData.js
var mergeData = __webpack_require__(8);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VLabel/VLabel.js
// Styles
 // Mixins



 // Helpers



/* @vue/component */

/* harmony default export */ var VLabel_VLabel = (Object(mixins["a" /* default */])(themeable["a" /* default */]).extend({
  name: 'v-label',
  functional: true,
  props: {
    absolute: Boolean,
    color: {
      type: String,
      default: 'primary'
    },
    disabled: Boolean,
    focused: Boolean,
    for: String,
    left: {
      type: [Number, String],
      default: 0
    },
    right: {
      type: [Number, String],
      default: 'auto'
    },
    value: Boolean
  },
  render(h, ctx) {
    const {
      children,
      listeners,
      props,
      data
    } = ctx;
    const newData = Object(mergeData["a" /* default */])({
      staticClass: 'v-label',
      class: {
        'v-label--active': props.value,
        'v-label--is-disabled': props.disabled,
        ...Object(themeable["b" /* functionalThemeClasses */])(ctx)
      },
      attrs: {
        for: props.for,
        'aria-hidden': !props.for
      },
      on: listeners,
      style: {
        left: Object(helpers["g" /* convertToUnit */])(props.left),
        right: Object(helpers["g" /* convertToUnit */])(props.right),
        position: props.absolute ? 'absolute' : 'relative'
      },
      ref: 'label'
    }, data);
    return h('label', colorable["a" /* default */].options.methods.setTextColor(props.focused && props.color, newData), children);
  }
}));
// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VLabel/index.js


/* harmony default export */ var components_VLabel = __webpack_exports__["a"] = (VLabel_VLabel);

/***/ }),

/***/ 116:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 117:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return attachedRoot; });
/**
 * Returns:
 *  - 'null' if the node is not attached to the DOM
 *  - the root node (HTMLDocument | ShadowRoot) otherwise
 */
function attachedRoot(node) {
  /* istanbul ignore next */
  if (typeof node.getRootNode !== 'function') {
    // Shadow DOM not supported (IE11), lets find the root of this node
    while (node.parentNode) node = node.parentNode; // The root parent is the document if the node is attached to the DOM

    if (node !== document) return null;
    return document;
  }
  const root = node.getRootNode(); // The composed root node is the document if the node is attached to the DOM

  if (root !== document && root.getRootNode({
    composed: true
  }) !== document) return null;
  return root;
}

/***/ }),

/***/ 118:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _colorable__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13);
/* harmony import */ var _themeable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12);
/* harmony import */ var _registrable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(47);
/* harmony import */ var _util_helpers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2);
/* harmony import */ var _util_console__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(3);
/* harmony import */ var _util_mixins__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(6);
// Mixins


 // Utilities




const baseMixins = Object(_util_mixins__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"])(_colorable__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"], Object(_registrable__WEBPACK_IMPORTED_MODULE_2__[/* inject */ "a"])('form'), _themeable__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"]);
/* @vue/component */

/* harmony default export */ __webpack_exports__["a"] = (baseMixins.extend({
  name: 'validatable',
  props: {
    disabled: {
      type: Boolean,
      default: null
    },
    error: Boolean,
    errorCount: {
      type: [Number, String],
      default: 1
    },
    errorMessages: {
      type: [String, Array],
      default: () => []
    },
    messages: {
      type: [String, Array],
      default: () => []
    },
    readonly: {
      type: Boolean,
      default: null
    },
    rules: {
      type: Array,
      default: () => []
    },
    success: Boolean,
    successMessages: {
      type: [String, Array],
      default: () => []
    },
    validateOnBlur: Boolean,
    value: {
      required: false
    }
  },
  data() {
    return {
      errorBucket: [],
      hasColor: false,
      hasFocused: false,
      hasInput: false,
      isFocused: false,
      isResetting: false,
      lazyValue: this.value,
      valid: false
    };
  },
  computed: {
    computedColor() {
      if (this.isDisabled) return undefined;
      if (this.color) return this.color; // It's assumed that if the input is on a
      // dark background, the user will want to
      // have a white color. If the entire app
      // is setup to be dark, then they will
      // like want to use their primary color

      if (this.isDark && !this.appIsDark) return 'white';else return 'primary';
    },
    hasError() {
      return this.internalErrorMessages.length > 0 || this.errorBucket.length > 0 || this.error;
    },
    // TODO: Add logic that allows the user to enable based
    // upon a good validation
    hasSuccess() {
      return this.internalSuccessMessages.length > 0 || this.success;
    },
    externalError() {
      return this.internalErrorMessages.length > 0 || this.error;
    },
    hasMessages() {
      return this.validationTarget.length > 0;
    },
    hasState() {
      if (this.isDisabled) return false;
      return this.hasSuccess || this.shouldValidate && this.hasError;
    },
    internalErrorMessages() {
      return this.genInternalMessages(this.errorMessages);
    },
    internalMessages() {
      return this.genInternalMessages(this.messages);
    },
    internalSuccessMessages() {
      return this.genInternalMessages(this.successMessages);
    },
    internalValue: {
      get() {
        return this.lazyValue;
      },
      set(val) {
        this.lazyValue = val;
        this.$emit('input', val);
      }
    },
    isDisabled() {
      var _a;
      return (_a = this.disabled) !== null && _a !== void 0 ? _a : !!this.form && this.form.disabled;
    },
    isInteractive() {
      return !this.isDisabled && !this.isReadonly;
    },
    isReadonly() {
      var _a;
      return (_a = this.readonly) !== null && _a !== void 0 ? _a : !!this.form && this.form.readonly;
    },
    shouldValidate() {
      if (this.externalError) return true;
      if (this.isResetting) return false;
      return this.validateOnBlur ? this.hasFocused && !this.isFocused : this.hasInput || this.hasFocused;
    },
    validations() {
      return this.validationTarget.slice(0, Number(this.errorCount));
    },
    validationState() {
      if (this.isDisabled) return undefined;
      if (this.hasError && this.shouldValidate) return 'error';
      if (this.hasSuccess) return 'success';
      if (this.hasColor) return this.computedColor;
      return undefined;
    },
    validationTarget() {
      if (this.internalErrorMessages.length > 0) {
        return this.internalErrorMessages;
      } else if (this.successMessages && this.successMessages.length > 0) {
        return this.internalSuccessMessages;
      } else if (this.messages && this.messages.length > 0) {
        return this.internalMessages;
      } else if (this.shouldValidate) {
        return this.errorBucket;
      } else return [];
    }
  },
  watch: {
    rules: {
      handler(newVal, oldVal) {
        if (Object(_util_helpers__WEBPACK_IMPORTED_MODULE_3__[/* deepEqual */ "j"])(newVal, oldVal)) return;
        this.validate();
      },
      deep: true
    },
    internalValue() {
      // If it's the first time we're setting input,
      // mark it with hasInput
      this.hasInput = true;
      this.validateOnBlur || this.$nextTick(this.validate);
    },
    isFocused(val) {
      // Should not check validation
      // if disabled
      if (!val && !this.isDisabled) {
        this.hasFocused = true;
        this.validateOnBlur && this.$nextTick(this.validate);
      }
    },
    isResetting() {
      setTimeout(() => {
        this.hasInput = false;
        this.hasFocused = false;
        this.isResetting = false;
        this.validate();
      }, 0);
    },
    hasError(val) {
      if (this.shouldValidate) {
        this.$emit('update:error', val);
      }
    },
    value(val) {
      this.lazyValue = val;
    }
  },
  beforeMount() {
    this.validate();
  },
  created() {
    this.form && this.form.register(this);
  },
  beforeDestroy() {
    this.form && this.form.unregister(this);
  },
  methods: {
    genInternalMessages(messages) {
      if (!messages) return [];else if (Array.isArray(messages)) return messages;else return [messages];
    },
    /** @public */
    reset() {
      this.isResetting = true;
      this.internalValue = Array.isArray(this.internalValue) ? [] : null;
    },
    /** @public */
    resetValidation() {
      this.isResetting = true;
    },
    /** @public */
    validate(force = false, value) {
      const errorBucket = [];
      value = value || this.internalValue;
      if (force) this.hasInput = this.hasFocused = true;
      for (let index = 0; index < this.rules.length; index++) {
        const rule = this.rules[index];
        const valid = typeof rule === 'function' ? rule(value) : rule;
        if (valid === false || typeof valid === 'string') {
          errorBucket.push(valid || '');
        } else if (typeof valid !== 'boolean') {
          Object(_util_console__WEBPACK_IMPORTED_MODULE_4__[/* consoleError */ "b"])(`Rules should return a string or boolean, received '${typeof valid}' instead`, this);
        }
      }
      this.errorBucket = errorBucket;
      this.valid = errorBucket.length === 0;
      return this.valid;
    }
  }
}));

/***/ }),

/***/ 120:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export Resize */
function inserted(el, binding, vnode) {
  const callback = binding.value;
  const options = binding.options || {
    passive: true
  };
  window.addEventListener('resize', callback, options);
  el._onResize = Object(el._onResize);
  el._onResize[vnode.context._uid] = {
    callback,
    options
  };
  if (!binding.modifiers || !binding.modifiers.quiet) {
    callback();
  }
}
function unbind(el, binding, vnode) {
  var _a;
  if (!((_a = el._onResize) === null || _a === void 0 ? void 0 : _a[vnode.context._uid])) return;
  const {
    callback,
    options
  } = el._onResize[vnode.context._uid];
  window.removeEventListener('resize', callback, options);
  delete el._onResize[vnode.context._uid];
}
const Resize = {
  inserted,
  unbind
};
/* harmony default export */ __webpack_exports__["a"] = (Resize);

/***/ }),

/***/ 127:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 128:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 129:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 131:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return intersectable; });
/* harmony import */ var _directives_intersect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(14);
/* harmony import */ var _util_console__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(3);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(0);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(vue__WEBPACK_IMPORTED_MODULE_2__);
// Directives
 // Utilities

 // Types


function intersectable(options) {
  return vue__WEBPACK_IMPORTED_MODULE_2___default.a.extend({
    name: 'intersectable',
    data: () => ({
      isIntersecting: false
    }),
    mounted() {
      _directives_intersect__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"].inserted(this.$el, {
        name: 'intersect',
        value: this.onObserve
      }, this.$vnode);
    },
    destroyed() {
      _directives_intersect__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"].unbind(this.$el, {
        name: 'intersect',
        value: this.onObserve
      }, this.$vnode);
    },
    methods: {
      onObserve(entries, observer, isIntersecting) {
        this.isIntersecting = isIntersecting;
        if (!isIntersecting) return;
        for (let i = 0, length = options.onVisible.length; i < length; i++) {
          const callback = this[options.onVisible[i]];
          if (typeof callback === 'function') {
            callback();
            continue;
          }
          Object(_util_console__WEBPACK_IMPORTED_MODULE_1__[/* consoleWarn */ "c"])(options.onVisible[i] + ' method is not available on the instance but referenced in intersectable mixin options');
        }
      }
    }
  });
}

/***/ }),

/***/ 132:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 136:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 153:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/FooterCard.vue?vue&type=template&id=97618a90&scoped=true
var render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticClass: "px-4"
  }, []);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/FooterCard.vue?vue&type=template&id=97618a90&scoped=true

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/FooterCard.vue?vue&type=script&lang=js
/* harmony default export */ var FooterCardvue_type_script_lang_js = ({
  data() {
    return {
      email: "",
      requiredRules: [v => !!v || 'Email is required']
    };
  },
  methods: {
    submitForm() {},
    validate() {
      if (this.$refs.form.validate()) {} else {
        console.log('error');
      }
    }
  }
});
// CONCATENATED MODULE: ./components/FooterCard.vue?vue&type=script&lang=js
 /* harmony default export */ var components_FooterCardvue_type_script_lang_js = (FooterCardvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/FooterCard.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(199)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_FooterCardvue_type_script_lang_js,
  render,
  staticRenderFns,
  false,
  injectStyles,
  "97618a90",
  "90a022ea"
  
)

/* harmony default export */ var FooterCard = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 158:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VTextField/VTextField.sass
var VTextField = __webpack_require__(132);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VInput/index.js + 3 modules
var VInput = __webpack_require__(114);

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VCounter/VCounter.sass
var VCounter = __webpack_require__(136);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/themeable/index.js
var themeable = __webpack_require__(12);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mixins.js
var mixins = __webpack_require__(6);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VCounter/VCounter.js
// Styles
 // Mixins



/* @vue/component */

/* harmony default export */ var VCounter_VCounter = (Object(mixins["a" /* default */])(themeable["a" /* default */]).extend({
  name: 'v-counter',
  functional: true,
  props: {
    value: {
      type: [Number, String],
      default: ''
    },
    max: [Number, String]
  },
  render(h, ctx) {
    const {
      props
    } = ctx;
    const max = parseInt(props.max, 10);
    const value = parseInt(props.value, 10);
    const content = max ? `${value} / ${max}` : String(props.value);
    const isGreater = max && value > max;
    return h('div', {
      staticClass: 'v-counter',
      class: {
        'error--text': isGreater,
        ...Object(themeable["b" /* functionalThemeClasses */])(ctx)
      }
    }, content);
  }
}));
// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VCounter/index.js


/* harmony default export */ var components_VCounter = (VCounter_VCounter);
// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VLabel/index.js + 1 modules
var VLabel = __webpack_require__(115);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/intersectable/index.js
var intersectable = __webpack_require__(131);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/loadable/index.js
var loadable = __webpack_require__(27);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/validatable/index.js
var validatable = __webpack_require__(118);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/directives/resize/index.js
var resize = __webpack_require__(120);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/directives/ripple/index.js
var ripple = __webpack_require__(46);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/dom.js
var dom = __webpack_require__(117);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/helpers.js
var helpers = __webpack_require__(2);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/console.js
var console = __webpack_require__(3);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VTextField/VTextField.js
// Styles
 // Extensions

 // Components


 // Mixins



 // Directives


 // Utilities



 // Types


const baseMixins = Object(mixins["a" /* default */])(VInput["a" /* default */], Object(intersectable["a" /* default */])({
  onVisible: ['onResize', 'tryAutofocus']
}), loadable["a" /* default */]);
const dirtyTypes = ['color', 'file', 'time', 'date', 'datetime-local', 'week', 'month'];
/* @vue/component */

/* harmony default export */ var VTextField_VTextField = __webpack_exports__["a"] = (baseMixins.extend().extend({
  name: 'v-text-field',
  directives: {
    resize: resize["a" /* default */],
    ripple: ripple["a" /* default */]
  },
  inheritAttrs: false,
  props: {
    appendOuterIcon: String,
    autofocus: Boolean,
    clearable: Boolean,
    clearIcon: {
      type: String,
      default: '$clear'
    },
    counter: [Boolean, Number, String],
    counterValue: Function,
    filled: Boolean,
    flat: Boolean,
    fullWidth: Boolean,
    label: String,
    outlined: Boolean,
    placeholder: String,
    prefix: String,
    prependInnerIcon: String,
    persistentPlaceholder: Boolean,
    reverse: Boolean,
    rounded: Boolean,
    shaped: Boolean,
    singleLine: Boolean,
    solo: Boolean,
    soloInverted: Boolean,
    suffix: String,
    type: {
      type: String,
      default: 'text'
    }
  },
  data: () => ({
    badInput: false,
    labelWidth: 0,
    prefixWidth: 0,
    prependWidth: 0,
    initialValue: null,
    isBooted: false,
    isClearing: false
  }),
  computed: {
    classes() {
      return {
        ...VInput["a" /* default */].options.computed.classes.call(this),
        'v-text-field': true,
        'v-text-field--full-width': this.fullWidth,
        'v-text-field--prefix': this.prefix,
        'v-text-field--single-line': this.isSingle,
        'v-text-field--solo': this.isSolo,
        'v-text-field--solo-inverted': this.soloInverted,
        'v-text-field--solo-flat': this.flat,
        'v-text-field--filled': this.filled,
        'v-text-field--is-booted': this.isBooted,
        'v-text-field--enclosed': this.isEnclosed,
        'v-text-field--reverse': this.reverse,
        'v-text-field--outlined': this.outlined,
        'v-text-field--placeholder': this.placeholder,
        'v-text-field--rounded': this.rounded,
        'v-text-field--shaped': this.shaped
      };
    },
    computedColor() {
      const computedColor = validatable["a" /* default */].options.computed.computedColor.call(this);
      if (!this.soloInverted || !this.isFocused) return computedColor;
      return this.color || 'primary';
    },
    computedCounterValue() {
      if (typeof this.counterValue === 'function') {
        return this.counterValue(this.internalValue);
      }
      return [...(this.internalValue || '').toString()].length;
    },
    hasCounter() {
      return this.counter !== false && this.counter != null;
    },
    hasDetails() {
      return VInput["a" /* default */].options.computed.hasDetails.call(this) || this.hasCounter;
    },
    internalValue: {
      get() {
        return this.lazyValue;
      },
      set(val) {
        this.lazyValue = val;
        this.$emit('input', this.lazyValue);
      }
    },
    isDirty() {
      var _a;
      return ((_a = this.lazyValue) === null || _a === void 0 ? void 0 : _a.toString().length) > 0 || this.badInput;
    },
    isEnclosed() {
      return this.filled || this.isSolo || this.outlined;
    },
    isLabelActive() {
      return this.isDirty || dirtyTypes.includes(this.type);
    },
    isSingle() {
      return this.isSolo || this.singleLine || this.fullWidth ||
      // https://material.io/components/text-fields/#filled-text-field
      this.filled && !this.hasLabel;
    },
    isSolo() {
      return this.solo || this.soloInverted;
    },
    labelPosition() {
      let offset = this.prefix && !this.labelValue ? this.prefixWidth : 0;
      if (this.labelValue && this.prependWidth) offset -= this.prependWidth;
      return this.$vuetify.rtl === this.reverse ? {
        left: offset,
        right: 'auto'
      } : {
        left: 'auto',
        right: offset
      };
    },
    showLabel() {
      return this.hasLabel && !(this.isSingle && this.labelValue);
    },
    labelValue() {
      return this.isFocused || this.isLabelActive || this.persistentPlaceholder;
    }
  },
  watch: {
    // labelValue: 'setLabelWidth', // moved to mounted, see #11533
    outlined: 'setLabelWidth',
    label() {
      this.$nextTick(this.setLabelWidth);
    },
    prefix() {
      this.$nextTick(this.setPrefixWidth);
    },
    isFocused: 'updateValue',
    value(val) {
      this.lazyValue = val;
    }
  },
  created() {
    /* istanbul ignore next */
    if (this.$attrs.hasOwnProperty('box')) {
      Object(console["a" /* breaking */])('box', 'filled', this);
    }
    /* istanbul ignore next */

    if (this.$attrs.hasOwnProperty('browser-autocomplete')) {
      Object(console["a" /* breaking */])('browser-autocomplete', 'autocomplete', this);
    }
    /* istanbul ignore if */

    if (this.shaped && !(this.filled || this.outlined || this.isSolo)) {
      Object(console["c" /* consoleWarn */])('shaped should be used with either filled or outlined', this);
    }
  },
  mounted() {
    // #11533
    this.$watch(() => this.labelValue, this.setLabelWidth);
    this.autofocus && this.tryAutofocus();
    requestAnimationFrame(() => {
      this.isBooted = true;
      requestAnimationFrame(() => {
        if (!this.isIntersecting) {
          this.onResize();
        }
      });
    });
  },
  methods: {
    /** @public */
    focus() {
      this.onFocus();
    },
    /** @public */
    blur(e) {
      // https://github.com/vuetifyjs/vuetify/issues/5913
      // Safari tab order gets broken if called synchronous
      window.requestAnimationFrame(() => {
        this.$refs.input && this.$refs.input.blur();
      });
    },
    clearableCallback() {
      this.$refs.input && this.$refs.input.focus();
      this.$nextTick(() => this.internalValue = null);
    },
    genAppendSlot() {
      const slot = [];
      if (this.$slots['append-outer']) {
        slot.push(this.$slots['append-outer']);
      } else if (this.appendOuterIcon) {
        slot.push(this.genIcon('appendOuter'));
      }
      return this.genSlot('append', 'outer', slot);
    },
    genPrependInnerSlot() {
      const slot = [];
      if (this.$slots['prepend-inner']) {
        slot.push(this.$slots['prepend-inner']);
      } else if (this.prependInnerIcon) {
        slot.push(this.genIcon('prependInner'));
      }
      return this.genSlot('prepend', 'inner', slot);
    },
    genIconSlot() {
      const slot = [];
      if (this.$slots.append) {
        slot.push(this.$slots.append);
      } else if (this.appendIcon) {
        slot.push(this.genIcon('append'));
      }
      return this.genSlot('append', 'inner', slot);
    },
    genInputSlot() {
      const input = VInput["a" /* default */].options.methods.genInputSlot.call(this);
      const prepend = this.genPrependInnerSlot();
      if (prepend) {
        input.children = input.children || [];
        input.children.unshift(prepend);
      }
      return input;
    },
    genClearIcon() {
      if (!this.clearable) return null; // if the text field has no content then don't display the clear icon.
      // We add an empty div because other controls depend on a ref to append inner

      if (!this.isDirty) {
        return this.genSlot('append', 'inner', [this.$createElement('div')]);
      }
      return this.genSlot('append', 'inner', [this.genIcon('clear', this.clearableCallback)]);
    },
    genCounter() {
      var _a, _b, _c;
      if (!this.hasCounter) return null;
      const max = this.counter === true ? this.attrs$.maxlength : this.counter;
      const props = {
        dark: this.dark,
        light: this.light,
        max,
        value: this.computedCounterValue
      };
      return (_c = (_b = (_a = this.$scopedSlots).counter) === null || _b === void 0 ? void 0 : _b.call(_a, {
        props
      })) !== null && _c !== void 0 ? _c : this.$createElement(components_VCounter, {
        props
      });
    },
    genControl() {
      return VInput["a" /* default */].options.methods.genControl.call(this);
    },
    genDefaultSlot() {
      return [this.genFieldset(), this.genTextFieldSlot(), this.genClearIcon(), this.genIconSlot(), this.genProgress()];
    },
    genFieldset() {
      if (!this.outlined) return null;
      return this.$createElement('fieldset', {
        attrs: {
          'aria-hidden': true
        }
      }, [this.genLegend()]);
    },
    genLabel() {
      if (!this.showLabel) return null;
      const data = {
        props: {
          absolute: true,
          color: this.validationState,
          dark: this.dark,
          disabled: this.isDisabled,
          focused: !this.isSingle && (this.isFocused || !!this.validationState),
          for: this.computedId,
          left: this.labelPosition.left,
          light: this.light,
          right: this.labelPosition.right,
          value: this.labelValue
        }
      };
      return this.$createElement(VLabel["a" /* default */], data, this.$slots.label || this.label);
    },
    genLegend() {
      const width = !this.singleLine && (this.labelValue || this.isDirty) ? this.labelWidth : 0;
      const span = this.$createElement('span', {
        domProps: {
          innerHTML: '&#8203;'
        },
        staticClass: 'notranslate'
      });
      return this.$createElement('legend', {
        style: {
          width: !this.isSingle ? Object(helpers["g" /* convertToUnit */])(width) : undefined
        }
      }, [span]);
    },
    genInput() {
      const listeners = Object.assign({}, this.listeners$);
      delete listeners.change; // Change should not be bound externally

      const {
        title,
        ...inputAttrs
      } = this.attrs$;
      return this.$createElement('input', {
        style: {},
        domProps: {
          value: this.type === 'number' && Object.is(this.lazyValue, -0) ? '-0' : this.lazyValue
        },
        attrs: {
          ...inputAttrs,
          autofocus: this.autofocus,
          disabled: this.isDisabled,
          id: this.computedId,
          placeholder: this.persistentPlaceholder || this.isFocused || !this.hasLabel ? this.placeholder : undefined,
          readonly: this.isReadonly,
          type: this.type
        },
        on: Object.assign(listeners, {
          blur: this.onBlur,
          input: this.onInput,
          focus: this.onFocus,
          keydown: this.onKeyDown
        }),
        ref: 'input',
        directives: [{
          name: 'resize',
          modifiers: {
            quiet: true
          },
          value: this.onResize
        }]
      });
    },
    genMessages() {
      if (!this.showDetails) return null;
      const messagesNode = VInput["a" /* default */].options.methods.genMessages.call(this);
      const counterNode = this.genCounter();
      return this.$createElement('div', {
        staticClass: 'v-text-field__details'
      }, [messagesNode, counterNode]);
    },
    genTextFieldSlot() {
      return this.$createElement('div', {
        staticClass: 'v-text-field__slot'
      }, [this.genLabel(), this.prefix ? this.genAffix('prefix') : null, this.genInput(), this.suffix ? this.genAffix('suffix') : null]);
    },
    genAffix(type) {
      return this.$createElement('div', {
        class: `v-text-field__${type}`,
        ref: type
      }, this[type]);
    },
    onBlur(e) {
      this.isFocused = false;
      e && this.$nextTick(() => this.$emit('blur', e));
    },
    onClick() {
      if (this.isFocused || this.isDisabled || !this.$refs.input) return;
      this.$refs.input.focus();
    },
    onFocus(e) {
      if (!this.$refs.input) return;
      const root = Object(dom["a" /* attachedRoot */])(this.$el);
      if (!root) return;
      if (root.activeElement !== this.$refs.input) {
        return this.$refs.input.focus();
      }
      if (!this.isFocused) {
        this.isFocused = true;
        e && this.$emit('focus', e);
      }
    },
    onInput(e) {
      const target = e.target;
      this.internalValue = target.value;
      this.badInput = target.validity && target.validity.badInput;
    },
    onKeyDown(e) {
      if (e.keyCode === helpers["s" /* keyCodes */].enter && this.lazyValue !== this.initialValue) {
        this.initialValue = this.lazyValue;
        this.$emit('change', this.initialValue);
      }
      this.$emit('keydown', e);
    },
    onMouseDown(e) {
      // Prevent input from being blurred
      if (e.target !== this.$refs.input) {
        e.preventDefault();
        e.stopPropagation();
      }
      VInput["a" /* default */].options.methods.onMouseDown.call(this, e);
    },
    onMouseUp(e) {
      if (this.hasMouseDown) this.focus();
      VInput["a" /* default */].options.methods.onMouseUp.call(this, e);
    },
    setLabelWidth() {
      if (!this.outlined) return;
      this.labelWidth = this.$refs.label ? Math.min(this.$refs.label.scrollWidth * 0.75 + 6, this.$el.offsetWidth - 24) : 0;
    },
    setPrefixWidth() {
      if (!this.$refs.prefix) return;
      this.prefixWidth = this.$refs.prefix.offsetWidth;
    },
    setPrependWidth() {
      if (!this.outlined || !this.$refs['prepend-inner']) return;
      this.prependWidth = this.$refs['prepend-inner'].offsetWidth;
    },
    tryAutofocus() {
      if (!this.autofocus || typeof document === 'undefined' || !this.$refs.input) return false;
      const root = Object(dom["a" /* attachedRoot */])(this.$el);
      if (!root || root.activeElement === this.$refs.input) return false;
      this.$refs.input.focus();
      return true;
    },
    updateValue(val) {
      // Sets validationState from validatable
      this.hasColor = val;
      if (val) {
        this.initialValue = this.lazyValue;
      } else if (this.initialValue !== this.lazyValue) {
        this.$emit('change', this.lazyValue);
      }
    },
    onResize() {
      this.setLabelWidth();
      this.setPrefixWidth();
      this.setPrependWidth();
    }
  }
}));

/***/ }),

/***/ 166:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 170:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 175:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VImg/VImg.js + 2 modules
var VImg = __webpack_require__(100);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/ApiBanner.vue?vue&type=template&id=6b74b885




var ApiBannervue_type_template_id_6b74b885_render = function render() {
  var _vm$banners, _vm$banners2, _vm$banners3, _vm$banners4;
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_c(VCard["a" /* default */], {
    attrs: {
      "tile": "",
      "elevation": "0"
    }
  }, [_c(VImg["a" /* default */], {
    attrs: {
      "src": 'https://newshop.testshop1.bimmer-tech.net' + ((_vm$banners = _vm.banners) === null || _vm$banners === void 0 ? void 0 : _vm$banners.image)
    }
  }, [_c('div', {
    staticClass: "bannerText",
    domProps: {
      "innerHTML": _vm._s((_vm$banners2 = _vm.banners) === null || _vm$banners2 === void 0 ? void 0 : _vm$banners2.text)
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "text-center mt-16"
  }, [_c(VBtn["a" /* default */], {
    attrs: {
      "color": (_vm$banners3 = _vm.banners) === null || _vm$banners3 === void 0 ? void 0 : _vm$banners3.btncolour
    }
  }, [_vm._v(_vm._s((_vm$banners4 = _vm.banners) === null || _vm$banners4 === void 0 ? void 0 : _vm$banners4.btntxt))])], 1)])], 1)], 1);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/ApiBanner.vue?vue&type=template&id=6b74b885

// EXTERNAL MODULE: external "vuex"
var external_vuex_ = __webpack_require__(9);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/ApiBanner.vue?vue&type=script&lang=js

/* harmony default export */ var ApiBannervue_type_script_lang_js = ({
  data: () => ({
    banners: []
  }),
  methods: {
    ...Object(external_vuex_["mapActions"])(["get_banner"]),
    getBanner() {
      this.randomNumber = Math.floor(Math.random() * 3);
      this.get_banner().then(response => {
        this.banners = response.data[this.randomNumber];
      }).catch(error => {
        console.log("error");
      });
    }
  },
  mounted() {
    this.getBanner();
  }
});
// CONCATENATED MODULE: ./components/ApiBanner.vue?vue&type=script&lang=js
 /* harmony default export */ var components_ApiBannervue_type_script_lang_js = (ApiBannervue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/ApiBanner.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(279)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_ApiBannervue_type_script_lang_js,
  ApiBannervue_type_template_id_6b74b885_render,
  staticRenderFns,
  false,
  injectStyles,
  null,
  "11665a56"
  
)

/* harmony default export */ var ApiBanner = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 199:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FooterCard_vue_vue_type_style_index_0_id_97618a90_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(170);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FooterCard_vue_vue_type_style_index_0_id_97618a90_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FooterCard_vue_vue_type_style_index_0_id_97618a90_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FooterCard_vue_vue_type_style_index_0_id_97618a90_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_FooterCard_vue_vue_type_style_index_0_id_97618a90_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 205:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 254:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VGrid/_grid.sass
var _grid = __webpack_require__(166);

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VGrid/VGrid.sass
var VGrid = __webpack_require__(53);

// EXTERNAL MODULE: external "vue"
var external_vue_ = __webpack_require__(0);
var external_vue_default = /*#__PURE__*/__webpack_require__.n(external_vue_);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VGrid/grid.js
// Types

function grid_VGrid(name) {
  /* @vue/component */
  return external_vue_default.a.extend({
    name: `v-${name}`,
    functional: true,
    props: {
      id: String,
      tag: {
        type: String,
        default: 'div'
      }
    },
    render(h, {
      props,
      data,
      children
    }) {
      data.staticClass = `${name} ${data.staticClass || ''}`.trim();
      const {
        attrs
      } = data;
      if (attrs) {
        // reset attrs to extract utility clases like pa-3
        data.attrs = {};
        const classes = Object.keys(attrs).filter(key => {
          // TODO: Remove once resolved
          // https://github.com/vuejs/vue/issues/7841
          if (key === 'slot') return false;
          const value = attrs[key]; // add back data attributes like data-test="foo" but do not
          // add them as classes

          if (key.startsWith('data-')) {
            data.attrs[key] = value;
            return false;
          }
          return value || typeof value === 'string';
        });
        if (classes.length) data.staticClass += ` ${classes.join(' ')}`;
      }
      if (props.id) {
        data.domProps = data.domProps || {};
        data.domProps.id = props.id;
      }
      return h(props.tag, data, children);
    }
  });
}
// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mergeData.js
var mergeData = __webpack_require__(8);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VGrid/VContainer.js




/* @vue/component */

/* harmony default export */ var VContainer = __webpack_exports__["a"] = (grid_VGrid('container').extend({
  name: 'v-container',
  functional: true,
  props: {
    id: String,
    tag: {
      type: String,
      default: 'div'
    },
    fluid: {
      type: Boolean,
      default: false
    }
  },
  render(h, {
    props,
    data,
    children
  }) {
    let classes;
    const {
      attrs
    } = data;
    if (attrs) {
      // reset attrs to extract utility clases like pa-3
      data.attrs = {};
      classes = Object.keys(attrs).filter(key => {
        // TODO: Remove once resolved
        // https://github.com/vuejs/vue/issues/7841
        if (key === 'slot') return false;
        const value = attrs[key]; // add back data attributes like data-test="foo" but do not
        // add them as classes

        if (key.startsWith('data-')) {
          data.attrs[key] = value;
          return false;
        }
        return value || typeof value === 'string';
      });
    }
    if (props.id) {
      data.domProps = data.domProps || {};
      data.domProps.id = props.id;
    }
    return h(props.tag, Object(mergeData["a" /* default */])(data, {
      staticClass: 'container',
      class: Array({
        'container--fluid': props.fluid
      }).concat(classes || [])
    }), children);
  }
}));

/***/ }),

/***/ 279:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ApiBanner_vue_vue_type_style_index_0_id_6b74b885_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(205);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ApiBanner_vue_vue_type_style_index_0_id_6b74b885_prod_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ApiBanner_vue_vue_type_style_index_0_id_6b74b885_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ApiBanner_vue_vue_type_style_index_0_id_6b74b885_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ApiBanner_vue_vue_type_style_index_0_id_6b74b885_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 293:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 299:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 331:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 332:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 333:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 334:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 335:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CompatibilityCard_vue_vue_type_style_index_0_id_003a313e_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(293);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CompatibilityCard_vue_vue_type_style_index_0_id_003a313e_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CompatibilityCard_vue_vue_type_style_index_0_id_003a313e_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CompatibilityCard_vue_vue_type_style_index_0_id_003a313e_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CompatibilityCard_vue_vue_type_style_index_0_id_003a313e_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 369:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/PostCards.vue?vue&type=template&id=24ba4aaa



var PostCardsvue_type_template_id_24ba4aaa_render = function render() {
  var _vm$blog, _vm$blog2, _vm$blog3;
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_vm._ssrNode("<a" + _vm._ssrAttr("href", `/blog/${_vm.blog.slug}`) + ">", "</a>", [_c(VCard["a" /* default */], {
    staticClass: "mt-2 elevation-0 pb-4",
    staticStyle: {
      "cursor": "pointer"
    },
    attrs: {
      "height": "375",
      "tile": ""
    }
  }, [_c('div', {
    attrs: {
      "height": "170px"
    }
  }, [_c('img', {
    attrs: {
      "src": 'https://newshop.testshop1.bimmer-tech.net' + _vm.blog.thumbnail.twoToOne,
      "alt": "latestPosts",
      "width": "100%"
    }
  })]), _vm._v(" "), _c('div', {
    staticClass: "mt-n2 elevation-0",
    staticStyle: {
      "height": "16px",
      "width": "100%"
    },
    style: {
      'background-color': `${_vm.blog.catColour}`
    },
    attrs: {
      "tile": ""
    }
  }), _vm._v(" "), _c('div', {
    staticClass: "mx-4"
  }, [_c('h3', {
    staticClass: "card-heading mt-4 text-18 line_24 FF_Manrope font-weight-bold black1--text"
  }, [_vm._v(_vm._s((_vm$blog = _vm.blog) === null || _vm$blog === void 0 ? void 0 : _vm$blog.title))]), _vm._v(" "), _c('div', {
    staticStyle: {
      "height": "67px",
      "overflow-y": "hidden"
    }
  }, [_c('p', {
    staticClass: "post_card_text line_1-4 card-text FF_Manrope black1--text text-14 font-weight-light pt-2",
    domProps: {
      "innerHTML": _vm._s((_vm$blog2 = _vm.blog) === null || _vm$blog2 === void 0 ? void 0 : _vm$blog2.seoText)
    }
  })]), _vm._v(" "), _c(VBtn["a" /* default */], {
    staticClass: "mt-4 elevation-0 black--text text-capitalize",
    attrs: {
      "x-small": "",
      "tile": "",
      "outlined": "",
      "color": ""
    }
  }, [_vm._v(" " + _vm._s((_vm$blog3 = _vm.blog) === null || _vm$blog3 === void 0 ? void 0 : _vm$blog3.category_name) + " ")])], 1)])], 1)]);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/PostCards.vue?vue&type=template&id=24ba4aaa

// EXTERNAL MODULE: external "moment"
var external_moment_ = __webpack_require__(102);
var external_moment_default = /*#__PURE__*/__webpack_require__.n(external_moment_);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/PostCards.vue?vue&type=script&lang=js

/* harmony default export */ var PostCardsvue_type_script_lang_js = ({
  props: ['blog'],
  computed: {
    formatCreatedAt() {
      var _this$blog;
      return external_moment_default()((_this$blog = this.blog) === null || _this$blog === void 0 ? void 0 : _this$blog.createdAt).format("MMM DD, YYYY");
    }
  },
  data() {
    return {};
  },
  methods: {
    truncateText(text, maxLength) {
      if (text.length > maxLength) {
        return text.slice(0, maxLength) + '...';
      }
      return text;
    }
  }
});
// CONCATENATED MODULE: ./components/PostCards.vue?vue&type=script&lang=js
 /* harmony default export */ var components_PostCardsvue_type_script_lang_js = (PostCardsvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/PostCards.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(403)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_PostCardsvue_type_script_lang_js,
  PostCardsvue_type_template_id_24ba4aaa_render,
  staticRenderFns,
  false,
  injectStyles,
  null,
  "93b1e6da"
  
)

/* harmony default export */ var PostCards = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 370:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/CategoriesCard.vue?vue&type=template&id=017e7c73&scoped=true


var CategoriesCardvue_type_template_id_017e7c73_scoped_true_render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_c(VCard["a" /* default */], {
    staticClass: "px-3 py-3 elevation-0",
    attrs: {
      "color": "transparent",
      "outlined": ""
    }
  }, [_c('p', {
    staticClass: "text-16 FF_Manrope black1--text font-weight-bold"
  }, [_vm._v("Categories:")]), _vm._v(" "), _vm._l(_vm.category, function (item, index) {
    return _c('div', {
      key: index
    }, [_c('a', {
      attrs: {
        "href": `blog-${item.slug}`
      }
    }, [_c('div', {
      staticClass: "d-flex justify-space-between"
    }, [_c('p', {
      staticClass: "FF_Manrope black--text text-14 font-weight-bold mb-0",
      class: {
        'hover-effect': _vm.isHovered[index]
      },
      on: {
        "mouseover": function ($event) {
          return _vm.setHover(index, true);
        },
        "mouseout": function ($event) {
          return _vm.setHover(index, false);
        }
      }
    }, [_vm._v("\n          " + _vm._s(item === null || item === void 0 ? void 0 : item.name) + "\n        ")]), _vm._v(" "), _c('p', {
      staticClass: "FF_Manrope grey--text text-14 font-weight-medium mb-0"
    }, [_vm._v("(" + _vm._s(item === null || item === void 0 ? void 0 : item.postCount) + ")")])])])]);
  })], 2)], 1);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/CategoriesCard.vue?vue&type=template&id=017e7c73&scoped=true

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/CategoriesCard.vue?vue&type=script&lang=js
/* harmony default export */ var CategoriesCardvue_type_script_lang_js = ({
  props: ['category'],
  data() {
    return {
      isHovered: Array(this.category.length).fill(false)
    };
  },
  methods: {
    setHover(index, value) {
      this.$set(this.isHovered, index, value);
    }
  }
});
// CONCATENATED MODULE: ./components/CategoriesCard.vue?vue&type=script&lang=js
 /* harmony default export */ var components_CategoriesCardvue_type_script_lang_js = (CategoriesCardvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/CategoriesCard.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(404)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_CategoriesCardvue_type_script_lang_js,
  CategoriesCardvue_type_template_id_017e7c73_scoped_true_render,
  staticRenderFns,
  false,
  injectStyles,
  "017e7c73",
  "516b1a0c"
  
)

/* harmony default export */ var CategoriesCard = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 371:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VTextField/VTextField.js + 2 modules
var VTextField = __webpack_require__(158);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/NewsletterCard.vue?vue&type=template&id=78517c12&scoped=true




var NewsletterCardvue_type_template_id_78517c12_scoped_true_render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_c(VCard["a" /* default */], {
    staticClass: "mt-3 px-3 py-3 elevation-0",
    attrs: {
      "color": "primary",
      "tile": "",
      "outlined": ""
    }
  }, [_c('div', [_c('p', {
    staticClass: "text-16 text-center FF_Manrope white--text font-weight-bold text-capitalize"
  }, [_vm._v("JOIN OUR NEWSLETTER")]), _vm._v(" "), _c('p', {
    staticClass: "text-center news-text FF_Manrope text-14 white--text font-weight-light"
  }, [_vm._v("To be up\n                to date with promotions and news "), _c('br'), _vm._v("\n                from the world of BMW join our newsletter.")]), _vm._v(" "), _c(VTextField["a" /* default */], {
    staticClass: "custom-text-field-newsletter mx-auto",
    attrs: {
      "outlined": "",
      "dense": "",
      "placeholder": "Enter Your Email"
    },
    scopedSlots: _vm._u([{
      key: "append",
      fn: function () {
        return [_c(VBtn["a" /* default */], {
          staticClass: "px-6 elevation-0 FF_Manrope white--text text-capitalize font-weight-light",
          staticStyle: {
            "border-radius": "10px !important"
          },
          attrs: {
            "color": "#1CA3C2"
          }
        }, [_vm._v("Subscribe")])];
      },
      proxy: true
    }])
  })], 1)])], 1);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/NewsletterCard.vue?vue&type=template&id=78517c12&scoped=true

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/NewsletterCard.vue?vue&type=script&lang=js
/* harmony default export */ var NewsletterCardvue_type_script_lang_js = ({
  data() {
    return {};
  }
});
// CONCATENATED MODULE: ./components/NewsletterCard.vue?vue&type=script&lang=js
 /* harmony default export */ var components_NewsletterCardvue_type_script_lang_js = (NewsletterCardvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/NewsletterCard.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(405)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_NewsletterCardvue_type_script_lang_js,
  NewsletterCardvue_type_template_id_78517c12_scoped_true_render,
  staticRenderFns,
  false,
  injectStyles,
  "78517c12",
  "e39428ae"
  
)

/* harmony default export */ var NewsletterCard = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 372:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/CompatibilityCard.vue?vue&type=template&id=003a313e&scoped=true



var CompatibilityCardvue_type_template_id_003a313e_scoped_true_render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_c(VCard["a" /* default */], {
    staticClass: "rounded-10 mt-3 px-5 py-5 text-center elevation-4",
    attrs: {
      "outlined": "",
      "color": "primary"
    }
  }, [_c('div', [_c('h1', {
    staticClass: "white--text FF_Rubik-regular text-28"
  }, [_vm._v("Let us find")]), _vm._v(" "), _c('h1', {
    staticClass: "white--text FF_Rubik-regular font-weight-thin text-36 px-3"
  }, [_vm._v("the right version for you")]), _vm._v(" "), _c('p', {
    staticClass: "white--text FF_Rubik-light font-weight-light text-18 mt-10 px-3 mb-15"
  }, [_vm._v("We'll confirm pricing, compatibility and product details for your car:")]), _vm._v(" "), _c(VBtn["a" /* default */], {
    staticClass: "px-16 text-capitalize",
    attrs: {
      "outlined": "",
      "rounded": "",
      "color": "white"
    }
  }, [_vm._v("Enter your VIN")])], 1)])], 1);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/CompatibilityCard.vue?vue&type=template&id=003a313e&scoped=true

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/CompatibilityCard.vue?vue&type=script&lang=js
/* harmony default export */ var CompatibilityCardvue_type_script_lang_js = ({
  data() {
    return {};
  }
});
// CONCATENATED MODULE: ./components/CompatibilityCard.vue?vue&type=script&lang=js
 /* harmony default export */ var components_CompatibilityCardvue_type_script_lang_js = (CompatibilityCardvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/CompatibilityCard.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(335)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_CompatibilityCardvue_type_script_lang_js,
  CompatibilityCardvue_type_template_id_003a313e_scoped_true_render,
  staticRenderFns,
  false,
  injectStyles,
  "003a313e",
  "558b2810"
  
)

/* harmony default export */ var CompatibilityCard = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 403:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PostCards_vue_vue_type_style_index_0_id_24ba4aaa_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(332);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PostCards_vue_vue_type_style_index_0_id_24ba4aaa_prod_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PostCards_vue_vue_type_style_index_0_id_24ba4aaa_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PostCards_vue_vue_type_style_index_0_id_24ba4aaa_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_PostCards_vue_vue_type_style_index_0_id_24ba4aaa_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 404:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CategoriesCard_vue_vue_type_style_index_0_id_017e7c73_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(333);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CategoriesCard_vue_vue_type_style_index_0_id_017e7c73_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CategoriesCard_vue_vue_type_style_index_0_id_017e7c73_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CategoriesCard_vue_vue_type_style_index_0_id_017e7c73_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_CategoriesCard_vue_vue_type_style_index_0_id_017e7c73_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 405:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_NewsletterCard_vue_vue_type_style_index_0_id_78517c12_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(334);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_NewsletterCard_vue_vue_type_style_index_0_id_78517c12_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_NewsletterCard_vue_vue_type_style_index_0_id_78517c12_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_NewsletterCard_vue_vue_type_style_index_0_id_78517c12_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_NewsletterCard_vue_vue_type_style_index_0_id_78517c12_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 459:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: ./node_modules/vuetify/src/components/VBreadcrumbs/VBreadcrumbs.sass
var VBreadcrumbs = __webpack_require__(299);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/routable/index.js
var routable = __webpack_require__(15);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/mixins.js
var mixins = __webpack_require__(6);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VBreadcrumbs/VBreadcrumbsItem.js


/* @vue/component */

/* harmony default export */ var VBreadcrumbsItem = (Object(mixins["a" /* default */])(routable["a" /* default */]).extend({
  name: 'v-breadcrumbs-item',
  props: {
    // In a breadcrumb, the currently
    // active item should be dimmed
    activeClass: {
      type: String,
      default: 'v-breadcrumbs__item--disabled'
    },
    ripple: {
      type: [Boolean, Object],
      default: false
    }
  },
  computed: {
    classes() {
      return {
        'v-breadcrumbs__item': true,
        [this.activeClass]: this.disabled
      };
    }
  },
  render(h) {
    const {
      tag,
      data
    } = this.generateRouteLink();
    return h('li', [h(tag, {
      ...data,
      attrs: {
        ...data.attrs,
        'aria-current': this.isActive && this.isLink ? 'page' : undefined
      }
    }, this.$slots.default)]);
  }
}));
// EXTERNAL MODULE: ./node_modules/vuetify/lib/util/helpers.js
var helpers = __webpack_require__(2);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VBreadcrumbs/VBreadcrumbsDivider.js

/* harmony default export */ var VBreadcrumbsDivider = (Object(helpers["i" /* createSimpleFunctional */])('v-breadcrumbs__divider', 'li'));
// EXTERNAL MODULE: ./node_modules/vuetify/lib/mixins/themeable/index.js
var themeable = __webpack_require__(12);

// CONCATENATED MODULE: ./node_modules/vuetify/lib/components/VBreadcrumbs/VBreadcrumbs.js
// Styles
 // Components


 // Mixins

 // Utils


/* harmony default export */ var VBreadcrumbs_VBreadcrumbs = __webpack_exports__["a"] = (Object(mixins["a" /* default */])(themeable["a" /* default */]
/* @vue/component */).extend({
  name: 'v-breadcrumbs',
  props: {
    divider: {
      type: String,
      default: '/'
    },
    items: {
      type: Array,
      default: () => []
    },
    large: Boolean
  },
  computed: {
    classes() {
      return {
        'v-breadcrumbs--large': this.large,
        ...this.themeClasses
      };
    }
  },
  methods: {
    genDivider() {
      return this.$createElement(VBreadcrumbsDivider, this.$slots.divider ? this.$slots.divider : this.divider);
    },
    genItems() {
      const items = [];
      const hasSlot = !!this.$scopedSlots.item;
      const keys = [];
      for (let i = 0; i < this.items.length; i++) {
        const item = this.items[i];
        keys.push(item.text);
        if (hasSlot) items.push(this.$scopedSlots.item({
          item
        }));else items.push(this.$createElement(VBreadcrumbsItem, {
          key: keys.join('.'),
          props: item
        }, [item.text]));
        if (i < this.items.length - 1) items.push(this.genDivider());
      }
      return items;
    }
  },
  render(h) {
    const children = this.$slots.default || this.genItems();
    return h('ul', {
      staticClass: 'v-breadcrumbs',
      class: this.classes
    }, children);
  }
}));

/***/ }),

/***/ 472:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "img/blog.803ed66.jpg";

/***/ }),

/***/ 473:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _src_components_VPagination_VPagination_sass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(331);
/* harmony import */ var _src_components_VPagination_VPagination_sass__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_src_components_VPagination_VPagination_sass__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _VIcon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(111);
/* harmony import */ var _directives_resize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(120);
/* harmony import */ var _mixins_colorable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(13);
/* harmony import */ var _mixins_intersectable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(131);
/* harmony import */ var _mixins_themeable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12);
/* harmony import */ var _util_mixins__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(6);

 // Directives

 // Mixins



 // Utilities


/* @vue/component */

/* harmony default export */ __webpack_exports__["a"] = (Object(_util_mixins__WEBPACK_IMPORTED_MODULE_6__[/* default */ "a"])(_mixins_colorable__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"], Object(_mixins_intersectable__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"])({
  onVisible: ['init']
}), _mixins_themeable__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"]).extend({
  name: 'v-pagination',
  directives: {
    Resize: _directives_resize__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"]
  },
  props: {
    circle: Boolean,
    disabled: Boolean,
    navigationColor: String,
    navigationTextColor: String,
    length: {
      type: Number,
      default: 0,
      validator: val => val % 1 === 0
    },
    nextIcon: {
      type: String,
      default: '$next'
    },
    prevIcon: {
      type: String,
      default: '$prev'
    },
    totalVisible: [Number, String],
    value: {
      type: Number,
      default: 0
    },
    pageAriaLabel: {
      type: String,
      default: '$vuetify.pagination.ariaLabel.page'
    },
    currentPageAriaLabel: {
      type: String,
      default: '$vuetify.pagination.ariaLabel.currentPage'
    },
    previousAriaLabel: {
      type: String,
      default: '$vuetify.pagination.ariaLabel.previous'
    },
    nextAriaLabel: {
      type: String,
      default: '$vuetify.pagination.ariaLabel.next'
    },
    wrapperAriaLabel: {
      type: String,
      default: '$vuetify.pagination.ariaLabel.wrapper'
    }
  },
  data() {
    return {
      maxButtons: 0,
      selected: null
    };
  },
  computed: {
    classes() {
      return {
        'v-pagination': true,
        'v-pagination--circle': this.circle,
        'v-pagination--disabled': this.disabled,
        ...this.themeClasses
      };
    },
    items() {
      const totalVisible = parseInt(this.totalVisible, 10);
      if (totalVisible === 0 || isNaN(this.length) || this.length > Number.MAX_SAFE_INTEGER) {
        return [];
      }
      const maxLength = Math.min(Math.max(0, totalVisible) || this.length, Math.max(0, this.maxButtons) || this.length, this.length);
      if (this.length <= maxLength) {
        return this.range(1, this.length);
      }
      const even = maxLength % 2 === 0 ? 1 : 0;
      const left = Math.floor(maxLength / 2);
      const right = this.length - left + 1 + even;
      if (this.value > left && this.value < right) {
        const firstItem = 1;
        const lastItem = this.length;
        const start = this.value - left + 2;
        const end = this.value + left - 2 - even;
        const secondItem = start - 1 === firstItem + 1 ? 2 : '...';
        const beforeLastItem = end + 1 === lastItem - 1 ? end + 1 : '...';
        return [1, secondItem, ...this.range(start, end), beforeLastItem, this.length];
      } else if (this.value === left) {
        const end = this.value + left - 1 - even;
        return [...this.range(1, end), '...', this.length];
      } else if (this.value === right) {
        const start = this.value - left + 1;
        return [1, '...', ...this.range(start, this.length)];
      } else {
        return [...this.range(1, left), '...', ...this.range(right, this.length)];
      }
    }
  },
  watch: {
    value() {
      this.init();
    }
  },
  beforeMount() {
    this.init();
  },
  methods: {
    init() {
      this.selected = null;
      this.onResize();
      this.$nextTick(this.onResize); // TODO: Change this (f75dee3a, cbdf7caa)

      setTimeout(() => this.selected = this.value, 100);
    },
    onResize() {
      const width = this.$el && this.$el.parentElement ? this.$el.parentElement.clientWidth : window.innerWidth;
      this.maxButtons = Math.floor((width - 96) / 42);
    },
    next(e) {
      e.preventDefault();
      this.$emit('input', this.value + 1);
      this.$emit('next');
    },
    previous(e) {
      e.preventDefault();
      this.$emit('input', this.value - 1);
      this.$emit('previous');
    },
    range(from, to) {
      const range = [];
      from = from > 0 ? from : 1;
      for (let i = from; i <= to; i++) {
        range.push(i);
      }
      return range;
    },
    genIcon(h, icon, disabled, fn, label) {
      return h('li', [h('button', this.setBackgroundColor(this.navigationColor, {
        staticClass: 'v-pagination__navigation',
        class: {
          'v-pagination__navigation--disabled': disabled
        },
        attrs: {
          disabled,
          type: 'button',
          'aria-label': label
        },
        on: disabled ? {} : {
          click: fn
        }
      }), [h(_VIcon__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"], {
        props: {
          color: this.navigationTextColor
        }
      }, [icon])])]);
    },
    genItem(h, i) {
      const color = i === this.value && (this.color || 'primary');
      const isCurrentPage = i === this.value;
      const ariaLabel = isCurrentPage ? this.currentPageAriaLabel : this.pageAriaLabel;
      return h('button', this.setBackgroundColor(color, {
        staticClass: 'v-pagination__item',
        class: {
          'v-pagination__item--active': i === this.value
        },
        attrs: {
          type: 'button',
          'aria-current': isCurrentPage,
          'aria-label': this.$vuetify.lang.t(ariaLabel, i)
        },
        on: {
          click: () => this.$emit('input', i)
        }
      }), [i.toString()]);
    },
    genItems(h) {
      return this.items.map((i, index) => {
        return h('li', {
          key: index
        }, [isNaN(Number(i)) ? h('span', {
          class: 'v-pagination__more'
        }, [i.toString()]) : this.genItem(h, i)]);
      });
    },
    genList(h, children) {
      return h('ul', {
        directives: [{
          modifiers: {
            quiet: true
          },
          name: 'resize',
          value: this.onResize
        }],
        class: this.classes
      }, children);
    }
  },
  render(h) {
    const children = [this.genIcon(h, this.$vuetify.rtl ? this.nextIcon : this.prevIcon, this.value <= 1, this.previous, this.$vuetify.lang.t(this.previousAriaLabel)), this.genItems(h), this.genIcon(h, this.$vuetify.rtl ? this.prevIcon : this.nextIcon, this.value >= this.length, this.next, this.$vuetify.lang.t(this.nextAriaLabel))];
    return h('nav', {
      attrs: {
        role: 'navigation',
        'aria-label': this.$vuetify.lang.t(this.wrapperAriaLabel)
      }
    }, [this.genList(h, children)]);
  }
}));

/***/ }),

/***/ 474:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 475:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 476:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 565:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_0_id_2b378e9f_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(474);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_0_id_2b378e9f_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_0_id_2b378e9f_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_0_id_2b378e9f_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_0_id_2b378e9f_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 566:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_1_id_2b378e9f_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(475);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_1_id_2b378e9f_prod_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_1_id_2b378e9f_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_1_id_2b378e9f_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blog_vue_vue_type_style_index_1_id_2b378e9f_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 567:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blogCat_vue_vue_type_style_index_0_id_c6a4f332_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(476);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blogCat_vue_vue_type_style_index_0_id_c6a4f332_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blogCat_vue_vue_type_style_index_0_id_c6a4f332_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blogCat_vue_vue_type_style_index_0_id_c6a4f332_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_blogCat_vue_vue_type_style_index_0_id_c6a4f332_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 626:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBreadcrumbs/VBreadcrumbs.js + 2 modules
var VBreadcrumbs = __webpack_require__(459);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VCol.js
var VCol = __webpack_require__(110);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VContainer.js + 1 modules
var VContainer = __webpack_require__(254);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VImg/VImg.js + 2 modules
var VImg = __webpack_require__(100);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VPagination/VPagination.js
var VPagination = __webpack_require__(473);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VRow.js
var VRow = __webpack_require__(109);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VTextField/VTextField.js + 2 modules
var VTextField = __webpack_require__(158);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./pages/blog.vue?vue&type=template&id=2b378e9f&scoped=true










var blogvue_type_template_id_2b378e9f_scoped_true_render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', {
    staticStyle: {
      "background-color": "#f7f7f7"
    }
  }, [_c(VImg["a" /* default */], {
    attrs: {
      "height": "220px",
      "cover": "",
      "src": __webpack_require__(472)
    }
  }, [_c(VRow["a" /* default */], {
    staticClass: "justify-center align-center"
  }, [_c(VCol["a" /* default */], {
    attrs: {
      "cols": "12",
      "lg": "5",
      "md": "12",
      "sm": "12"
    }
  }, [_c(VCard["a" /* default */], {
    staticClass: "mx-auto mt-lg-6 mt-4 mb-5 pa-3",
    attrs: {
      "color": "transparent",
      "elevation": "0",
      "width": "95%"
    }
  }, [_c('div', {
    staticClass: "text-center"
  }, [_c('p', {
    staticClass: "text-36 white--text mb-0 FF_Rubik-medium font-weight-medium"
  }, [_vm._v("\n              Perfect technology blogs\n            ")]), _vm._v(" "), _c('p', {
    staticClass: "font-weight-light text-48 FF_Rubik-light white--text mb-0 mt-0"
  }, [_vm._v("\n              for your BMW/MINI\n            ")])])])], 1)], 1)], 1), _vm._ssrNode(" "), _vm._ssrNode("<div data-v-2b378e9f>", "</div>", [_c(VContainer["a" /* default */], [_c('div', [_c(VBreadcrumbs["a" /* default */], {
    staticClass: "font-weight-light text-12 black1--text pl-0",
    attrs: {
      "items": _vm.items,
      "divider": "/"
    }
  })], 1), _vm._v(" "), _c(VRow["a" /* default */], [_c(VCol["a" /* default */], {
    attrs: {
      "cols": "12",
      "lg": "8"
    }
  }, [_c(VRow["a" /* default */], _vm._l(_vm.Pages, function (item, index) {
    return _c(VCol["a" /* default */], {
      key: index,
      attrs: {
        "cols": "12",
        "lg": "6"
      }
    }, [_c('PostCards', {
      staticClass: "my-5",
      attrs: {
        "blog": item
      }
    })], 1);
  }), 1), _vm._v(" "), _c('div', {
    staticClass: "text-center"
  }, [_c(VPagination["a" /* default */], {
    staticClass: "elevation-0",
    attrs: {
      "total-visible": 10,
      "show-first-last-page": false,
      "length": Math.ceil(this.blogs.length / _vm.perPage)
    },
    model: {
      value: _vm.page,
      callback: function ($$v) {
        _vm.page = $$v;
      },
      expression: "page"
    }
  })], 1)], 1), _vm._v(" "), _c(VCol["a" /* default */], {
    attrs: {
      "cols": "12",
      "lg": "4"
    }
  }, [_c('CategoriesCard', {
    attrs: {
      "category": _vm.categories
    }
  }), _vm._v(" "), _c('NewsletterCard'), _vm._v(" "), _c(VCard["a" /* default */], {
    staticClass: "mt-3 px-3 py-3 elevation-0",
    attrs: {
      "color": "primary",
      "tile": "",
      "outlined": ""
    }
  }, [_c('div', [_c('p', {
    staticClass: "text-18 text-center FF_Manrope white--text font-weight-bold text-capitalize"
  }, [_vm._v("Let us find the right "), _c('br'), _vm._v(" version for you:")]), _vm._v(" "), _c('p', {
    staticClass: "text-center news-text FF_Manrope text-12 white--text font-weight-regular"
  }, [_vm._v("* Only by entering your VIN can you be 100% sure you get the right version of the product for your vehicle..")]), _vm._v(" "), _c('div', {
    staticClass: "px-6"
  }, [_c(VTextField["a" /* default */], {
    staticClass: "headerr newsletter mx-auto",
    attrs: {
      "outlined": "",
      "dense": "",
      "hide-details": "true",
      "placeholder": "Enter Your VIN"
    },
    scopedSlots: _vm._u([{
      key: "append",
      fn: function () {
        return [_c(VBtn["a" /* default */], {
          staticClass: "px-6 elevation-0 newsLetter FF_Manrope white--text text-capitalize font-weight-light",
          staticStyle: {
            "border-top-right-radius": "5px !important",
            "border-bottom-right-radius": "5px !important"
          },
          attrs: {
            "x-small": "",
            "color": "#428EA6"
          }
        }, [_vm._v("check")])];
      },
      proxy: true
    }])
  }), _vm._v(" "), _c('p', {
    staticClass: "FF_Manrope text-12 font-weight-regular white--text text-center mt-4",
    staticStyle: {
      "text-decoration": "underline"
    }
  }, [_vm._v("Where to find your VIN?")])], 1)])])], 1)], 1), _vm._v(" "), _c('FooterCard', {
    staticClass: "mb-16",
    staticStyle: {
      "overflow": "hidden"
    }
  })], 1)], 1)], 2);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./pages/blog.vue?vue&type=template&id=2b378e9f&scoped=true

// EXTERNAL MODULE: external "vuex"
var external_vuex_ = __webpack_require__(9);

// EXTERNAL MODULE: ./components/PostCards.vue + 4 modules
var PostCards = __webpack_require__(369);

// EXTERNAL MODULE: ./components/CategoriesCard.vue + 4 modules
var CategoriesCard = __webpack_require__(370);

// EXTERNAL MODULE: ./components/NewsletterCard.vue + 4 modules
var NewsletterCard = __webpack_require__(371);

// EXTERNAL MODULE: ./components/CompatibilityCard.vue + 4 modules
var CompatibilityCard = __webpack_require__(372);

// EXTERNAL MODULE: ./components/FooterCard.vue + 4 modules
var FooterCard = __webpack_require__(153);

// EXTERNAL MODULE: ./components/ApiBanner.vue + 4 modules
var ApiBanner = __webpack_require__(175);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./pages/blog.vue?vue&type=script&lang=js







/* harmony default export */ var blogvue_type_script_lang_js = ({
  components: {
    PostCards: PostCards["default"],
    CategoriesCard: CategoriesCard["default"],
    Newsletter: NewsletterCard["default"],
    CompatibilityCard: CompatibilityCard["default"],
    FooterCard: FooterCard["default"],
    ApiBanner: ApiBanner["default"]
  },
  data() {
    return {
      progress: this.displayBlog / this.totalBlog * 100,
      banner: "",
      page: 1,
      perPage: 8,
      items: [{
        text: "Home",
        disabled: false,
        href: "/"
      }, {
        text: "Bimmertech Blog",
        disabled: false,
        href: "Bimmertech Blog"
      }],
      blogs: [{
        id: 14,
        title: "SiriusXM Satellite Radio for Your BMW: a Siriusly Cool and Easy DIY Upgrade",
        catId: 10,
        category_name: "testing",
        catSlug: "bmw-performance",
        date: "2022-01-14 10:36:39",
        createdAt: "2022-01-14",
        enable: true,
        slug: "3-satellite-radio-for-your-bmw-a-sirius-ly-cool-and-easy-diy-upgrade",
        author: "BimmerTech",
        seoText: "<p>This is your lucky day if you own a 2010 or later BMW and have been wondering just how great SiriusXM Satellite Radio would sound in your car. Answer: awesome. But that&rsquo;s not all.</p>",
        thumbnail: {
          twoToOne: "/media/image/90/83/1fe8be412bffaa3ea191f655da3e.jpeg",
          oneToOne: "/media/image/d2/fe/d707ccb85477b95a94253e4f8825.jpeg"
        },
        heading_content_enabled: true,
        h3ContentEnabled: true,
        openGraphImage: "",
        lang: "en",
        h4ContentEnabled: true
      }],
      popularBlogs: [{
        id: 63,
        title: "Basic BMW Navigation Systems: CHAMP2, ENTRY, ENTRYNAV \u0026 ENAVEVO",
        catId: 3,
        category_name: "iDrive Technology Insights",
        catSlug: "idrive-technology-insights",
        date: "2020-10-20 13:23:08",
        createdAt: "2020-10-20",
        enable: true,
        slug: "101-basic-bmw-navigation",
        author: "Anastasiia Husieva",
        seoText: "When buying a new BMW, you usually purchase not only a vehicle for transportation, but also a tech convenience that has limited or extended navigation \u0026 a certain degree of integration with your smartphone. While setting up your future vehicle, you generally have 2\u20134 media packages. The Media Package is a number of multimedia and technical features that you will get in your car, and the more it includes, the more expensive your BMW\u2019s overall price is.",
        thumbnail: {
          twoToOne: "\/media\/image\/\/1f\/fb\/2_1.jpeg",
          oneToOne: "\/media\/image\/\/26\/02\/1_1.png"
        },
        heading_content_enabled: true,
        h3ContentEnabled: true,
        openGraphImage: null,
        lang: "en",
        h4ContentEnabled: false
      }],
      displayBlog: 6,
      // Initial number of items to display
      totalBlog: 0,
      // Total number of items available from the API

      categories: [{
        id: 1,
        slug: "bmw-camera-retrofit",
        name: "BMW Camera Retrofit",
        seoTitle: "New Seo Title",
        seoText: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ultricies feugiat commodo, tempor, vitae accumsan, a, nunc et cras. Pellentesque vulputate ut arcu enim eget commodo, et morbi. Auctor nulla dictum maecenas eu. Commodo, vitae elementum leo id habitant morbi id placerat. Suspendisse nisl placerat neque habitant consequat odio. Urna fames vitae tristique at. Adipiscing leo amet elit phasellus senectus amet pellentesque aliquet tempus. Mattis in metus, sagittis a mattis blandit interdum purus risus.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ultricies feugiat commodo, tempor, vitae accumsan, a, nunc et cras. Pellentesque vulputate ut arcu enim eget commodo, et morbi. Auctor nulla dictum maecenas eu. Commodo, vitae elementum leo id habitant morbi id placerat. Suspendisse nisl placerat neque habitant consequat odio. Urna fames vitae tristique at. Adipiscing leo amet elit phasellus senectus amet pellentesque aliquet tempus. Mattis in metus, sagittis a mattis blandit interdum purus risus.",
        postCount: 3
      }]
    };
  },
  computed: {
    displayedItems() {
      return this.blogs.slice(0, this.displayBlog);
    },
    Pages() {
      var _this$blogs;
      return (_this$blogs = this.blogs) === null || _this$blogs === void 0 ? void 0 : _this$blogs.slice((this.page - 1) * this.perPage, this.page * this.perPage);
    },
    showBadge() {
      if (false) {}
      return this.vinNumber;
    }
  },
  methods: {
    ...Object(external_vuex_["mapActions"])(["get_blogs", "get_banner", "get_popular_blogs"]),
    getBlogsData() {
      let val = "";
      this.get_blogs(val).then(response => {
        this.blogs = response.data.data.latest;
        this.totalBlog = this.blogs.length;
        this.categories = response.data.data.catData;
      }).catch(error => {
        console.log("error");
      });
    },
    getBanner() {
      this.get_banner().then(response => {
        this.banner = response.data[1];
      }).catch(error => {
        console.log("error");
      });
    },
    getPopularBlogsData() {
      this.get_popular_blogs().then(response => {
        this.popularBlogs = response.data;
      }).catch(error => {
        console.log("error");
      });
    },
    loadMore() {
      // Increase the display count by 6 when "Load More" is clicked
      this.displayBlog += 6;
      this.progress = this.displayBlog / this.totalBlog * 100;
    }
  },
  mounted() {
    this.getBlogsData();
    this.getPopularBlogsData(); // Call getPopularBlogsData to fetch popular blogs
    this.getBanner();
  }
});
// CONCATENATED MODULE: ./pages/blog.vue?vue&type=script&lang=js
 /* harmony default export */ var pages_blogvue_type_script_lang_js = (blogvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./pages/blog.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(565)
if (style0.__inject__) style0.__inject__(context)
var style1 = __webpack_require__(566)
if (style1.__inject__) style1.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  pages_blogvue_type_script_lang_js,
  blogvue_type_template_id_2b378e9f_scoped_true_render,
  staticRenderFns,
  false,
  injectStyles,
  "2b378e9f",
  "c3d4ded4"
  
)

/* harmony default export */ var blog = __webpack_exports__["default"] = (component.exports);

/* nuxt-component-imports */
installComponents(component, {PostCards: __webpack_require__(369).default,CategoriesCard: __webpack_require__(370).default,NewsletterCard: __webpack_require__(371).default,FooterCard: __webpack_require__(153).default})


/***/ }),

/***/ 627:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBreadcrumbs/VBreadcrumbs.js + 2 modules
var VBreadcrumbs = __webpack_require__(459);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VCol.js
var VCol = __webpack_require__(110);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VContainer.js + 1 modules
var VContainer = __webpack_require__(254);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VImg/VImg.js + 2 modules
var VImg = __webpack_require__(100);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VProgressLinear/VProgressLinear.js
var VProgressLinear = __webpack_require__(31);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VRow.js
var VRow = __webpack_require__(109);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./pages/blogCat.vue?vue&type=template&id=c6a4f332&scoped=true









var blogCatvue_type_template_id_c6a4f332_scoped_true_render = function render() {
  var _vm = this,
    _c = _vm._self._c;
  return _c('div', [_c(VImg["a" /* default */], {
    attrs: {
      "height": "220px",
      "cover": "",
      "src": __webpack_require__(472)
    }
  }, [_c(VRow["a" /* default */], {
    staticClass: "justify-center align-center"
  }, [_c(VCol["a" /* default */], {
    attrs: {
      "cols": "12",
      "lg": "5",
      "md": "12",
      "sm": "12"
    }
  }, [_c(VCard["a" /* default */], {
    staticClass: "mx-auto mt-lg-6 mt-4 mb-5 rounded-xl pa-3",
    attrs: {
      "color": "transparent",
      "elevation": "0",
      "width": "95%"
    }
  }, [_c('div', {
    staticClass: "text-center"
  }, [_c('p', {
    staticClass: "text-36 white--text mb-0 FF_Rubik-medium font-weight-medium"
  }, [_vm._v("Perfect technology blogs\n                        ")]), _vm._v(" "), _c('p', {
    staticClass: "font-weight-light text-48 FF_Rubik-light white--text mb-0 mt-0"
  }, [_vm._v("for your BMW/MINI")])])])], 1)], 1)], 1), _vm._ssrNode(" "), _vm._ssrNode("<div data-v-c6a4f332>", "</div>", [_c(VContainer["a" /* default */], [_c('div', [_c(VBreadcrumbs["a" /* default */], {
    staticClass: "font-weight-light text-12 black1--text pl-0",
    attrs: {
      "items": _vm.items,
      "divider": "/"
    }
  })], 1), _vm._v(" "), _c(VRow["a" /* default */], [_c(VCol["a" /* default */], {
    attrs: {
      "cols": "12",
      "lg": "8"
    }
  }, [_c('h1', {
    staticClass: "FF_Rubik-medium mb-5 font-weight-medium text-28"
  }, [_vm._v("Latest posts")]), _vm._v(" "), _c('div', [_c(VRow["a" /* default */], _vm._l(_vm.displayedItems, function (item, index) {
    return _c(VCol["a" /* default */], {
      attrs: {
        "cols": "12",
        "lg": "6"
      }
    }, [_c('PostCards', {
      key: index,
      staticClass: "my-5",
      attrs: {
        "blog": item
      }
    })], 1);
  }), 1), _vm._v(" "), _c('div', [_c(VProgressLinear["a" /* default */], {
    staticClass: "mt-5 post_progress_bar rounded",
    attrs: {
      "value": _vm.displayBlog
    }
  }), _vm._v(" "), _c('p', {
    staticClass: "text-center FF_Rubik-light mt-2 black1--text text-11 font-weight-thin"
  }, [_vm._v("\n                                You've viewed  "), _vm.displayBlog < _vm.totalBlog ? _c('span', [_vm._v(_vm._s(_vm.displayBlog))]) : _c('span', [_vm._v(_vm._s(_vm.totalBlog))]), _vm._v(" of " + _vm._s(_vm.totalBlog) + " posts")]), _vm._v(" "), _c('div', {
    staticClass: "text-center"
  }, [_vm.displayBlog < _vm.totalBlog ? _c(VBtn["a" /* default */], {
    staticClass: "primary--text font-weight-light text-capitalize",
    attrs: {
      "text": ""
    },
    on: {
      "click": _vm.loadMore
    }
  }, [_vm._v("\n                                    Load more\n                                ")]) : _vm._e()], 1)], 1), _vm._v(" "), _c('h1', [_vm._v("Popular posts:")]), _vm._v(" "), _vm._l(_vm.popularBlogs, function (item, index) {
    return _c('PostCards', {
      key: index,
      staticClass: "my-5",
      attrs: {
        "blog": item
      }
    });
  })], 2)]), _vm._v(" "), _c(VCol["a" /* default */], {
    attrs: {
      "cols": "12",
      "lg": "4"
    }
  }, [_c('CategoriesCard', {
    attrs: {
      "category": _vm.categories
    }
  }), _vm._v(" "), _c('NewsletterCard'), _vm._v(" "), _c('ApiBanner', {
    staticClass: "mt-5 sticky-column"
  })], 1)], 1), _vm._v(" "), _c('FooterCard', {
    staticClass: "mb-16",
    staticStyle: {
      "overflow": "hidden"
    }
  })], 1)], 1)], 2);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./pages/blogCat.vue?vue&type=template&id=c6a4f332&scoped=true

// EXTERNAL MODULE: external "vuex"
var external_vuex_ = __webpack_require__(9);

// EXTERNAL MODULE: ./components/PostCards.vue + 4 modules
var PostCards = __webpack_require__(369);

// EXTERNAL MODULE: ./components/CategoriesCard.vue + 4 modules
var CategoriesCard = __webpack_require__(370);

// EXTERNAL MODULE: ./components/NewsletterCard.vue + 4 modules
var NewsletterCard = __webpack_require__(371);

// EXTERNAL MODULE: ./components/CompatibilityCard.vue + 4 modules
var CompatibilityCard = __webpack_require__(372);

// EXTERNAL MODULE: ./components/FooterCard.vue + 4 modules
var FooterCard = __webpack_require__(153);

// EXTERNAL MODULE: ./components/ApiBanner.vue + 4 modules
var ApiBanner = __webpack_require__(175);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./pages/blogCat.vue?vue&type=script&lang=js







/* harmony default export */ var blogCatvue_type_script_lang_js = ({
  components: {
    PostCards: PostCards["default"],
    CategoriesCard: CategoriesCard["default"],
    Newsletter: NewsletterCard["default"],
    CompatibilityCard: CompatibilityCard["default"],
    FooterCard: FooterCard["default"],
    ApiBanner: ApiBanner["default"]
  },
  data() {
    return {
      banner: '',
      items: [{
        text: "Home",
        disabled: false,
        href: '/'
      }, {
        text: "Bimmertech Blog",
        disabled: false,
        href: 'Bimmertech Blog'
      }],
      blogs: [{
        id: 14,
        title: "SiriusXM Satellite Radio for Your BMW: a Siriusly Cool and Easy DIY Upgrade",
        catId: 10,
        category_name: "testing",
        catSlug: "bmw-performance",
        date: "2022-01-14 10:36:39",
        createdAt: "2022-01-14",
        enable: true,
        slug: "3-satellite-radio-for-your-bmw-a-sirius-ly-cool-and-easy-diy-upgrade",
        author: "BimmerTech",
        seoText: "<p>This is your lucky day if you own a 2010 or later BMW and have been wondering just how great SiriusXM Satellite Radio would sound in your car. Answer: awesome. But that&rsquo;s not all.</p>",
        thumbnail: {
          twoToOne: "/media/image/90/83/1fe8be412bffaa3ea191f655da3e.jpeg",
          oneToOne: "/media/image/d2/fe/d707ccb85477b95a94253e4f8825.jpeg"
        },
        heading_content_enabled: true,
        h3ContentEnabled: true,
        openGraphImage: "",
        lang: "en",
        h4ContentEnabled: true
      }],
      popularBlogs: [{
        id: 63,
        title: "Basic BMW Navigation Systems: CHAMP2, ENTRY, ENTRYNAV \u0026 ENAVEVO",
        catId: 3,
        category_name: "iDrive Technology Insights",
        catSlug: "idrive-technology-insights",
        date: "2020-10-20 13:23:08",
        createdAt: "2020-10-20",
        enable: true,
        slug: "101-basic-bmw-navigation",
        author: "Anastasiia Husieva",
        seoText: "When buying a new BMW, you usually purchase not only a vehicle for transportation, but also a tech convenience that has limited or extended navigation \u0026 a certain degree of integration with your smartphone. While setting up your future vehicle, you generally have 2\u20134 media packages. The Media Package is a number of multimedia and technical features that you will get in your car, and the more it includes, the more expensive your BMW\u2019s overall price is.",
        "thumbnail": {
          twoToOne: "\/media\/image\/\/1f\/fb\/2_1.jpeg",
          oneToOne: "\/media\/image\/\/26\/02\/1_1.png"
        },
        heading_content_enabled: true,
        h3ContentEnabled: true,
        openGraphImage: null,
        lang: "en",
        h4ContentEnabled: false
      }],
      displayBlog: 6,
      // Initial number of items to display
      totalBlog: 0,
      // Total number of items available from the API

      categories: [{
        id: 1,
        slug: "bmw-camera-retrofit",
        name: "BMW Camera Retrofit",
        seoTitle: "New Seo Title",
        seoText: "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ultricies feugiat commodo, tempor, vitae accumsan, a, nunc et cras. Pellentesque vulputate ut arcu enim eget commodo, et morbi. Auctor nulla dictum maecenas eu. Commodo, vitae elementum leo id habitant morbi id placerat. Suspendisse nisl placerat neque habitant consequat odio. Urna fames vitae tristique at. Adipiscing leo amet elit phasellus senectus amet pellentesque aliquet tempus. Mattis in metus, sagittis a mattis blandit interdum purus risus.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ultricies feugiat commodo, tempor, vitae accumsan, a, nunc et cras. Pellentesque vulputate ut arcu enim eget commodo, et morbi. Auctor nulla dictum maecenas eu. Commodo, vitae elementum leo id habitant morbi id placerat. Suspendisse nisl placerat neque habitant consequat odio. Urna fames vitae tristique at. Adipiscing leo amet elit phasellus senectus amet pellentesque aliquet tempus. Mattis in metus, sagittis a mattis blandit interdum purus risus.",
        postCount: 3
      }]
    };
  },
  computed: {
    displayedItems() {
      return this.blogs.slice(0, this.displayBlog);
    },
    showBadge() {
      if (false) {}
      return this.vinNumber;
    }
  },
  methods: {
    ...Object(external_vuex_["mapActions"])(["get_blogs", "get_banner", "get_popular_blogs"]),
    getBlogsData() {
      let val = this.$route.params.id;
      this.get_blogs(val).then(response => {
        this.blogs = response.data.data.latest;
        this.totalBlog = this.blogs.length;
        this.categories = response.data.data.catData;
      }).catch(error => {
        console.log("error");
      });
    },
    getBanner() {
      this.get_banner().then(response => {
        this.banner = response.data[1];
      }).catch(error => {
        console.log("error");
      });
    },
    getPopularBlogsData() {
      this.get_popular_blogs().then(response => {
        this.popularBlogs = response.data;
      }).catch(error => {
        console.log("error");
      });
    },
    loadMore() {
      // Increase the display count by 6 when "Load More" is clicked
      this.displayBlog += 6;
    }
  },
  mounted() {
    this.getBlogsData();
    this.getPopularBlogsData(); // Call getPopularBlogsData to fetch popular blogs
    this.getBanner();
  }
});
// CONCATENATED MODULE: ./pages/blogCat.vue?vue&type=script&lang=js
 /* harmony default export */ var pages_blogCatvue_type_script_lang_js = (blogCatvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./pages/blogCat.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(567)
if (style0.__inject__) style0.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  pages_blogCatvue_type_script_lang_js,
  blogCatvue_type_template_id_c6a4f332_scoped_true_render,
  staticRenderFns,
  false,
  injectStyles,
  "c6a4f332",
  "bb272ee0"
  
)

/* harmony default export */ var blogCat = __webpack_exports__["default"] = (component.exports);

/* nuxt-component-imports */
installComponents(component, {PostCards: __webpack_require__(369).default,CategoriesCard: __webpack_require__(370).default,NewsletterCard: __webpack_require__(371).default,ApiBanner: __webpack_require__(175).default,FooterCard: __webpack_require__(153).default})


/***/ })

};;
//# sourceMappingURL=index.js.map