exports.ids = [39];
exports.modules = {

/***/ 113:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _src_components_VIcon_VIcon_sass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(116);
/* harmony import */ var _src_components_VIcon_VIcon_sass__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_src_components_VIcon_VIcon_sass__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mixins_binds_attrs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44);
/* harmony import */ var _mixins_colorable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
/* harmony import */ var _mixins_sizeable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(48);
/* harmony import */ var _mixins_themeable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12);
/* harmony import */ var _util_helpers__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(2);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(0);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(vue__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _util_mixins__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(6);
 // Mixins




 // Util

 // Types



var SIZE_MAP;
(function (SIZE_MAP) {
  SIZE_MAP["xSmall"] = "12px";
  SIZE_MAP["small"] = "16px";
  SIZE_MAP["default"] = "24px";
  SIZE_MAP["medium"] = "28px";
  SIZE_MAP["large"] = "36px";
  SIZE_MAP["xLarge"] = "40px";
})(SIZE_MAP || (SIZE_MAP = {}));
function isFontAwesome5(iconType) {
  return ['fas', 'far', 'fal', 'fab', 'fad', 'fak'].some(val => iconType.includes(val));
}
function isSvgPath(icon) {
  return /^[mzlhvcsqta]\s*[-+.0-9][^mlhvzcsqta]+/i.test(icon) && /[\dz]$/i.test(icon) && icon.length > 4;
}
const VIcon = Object(_util_mixins__WEBPACK_IMPORTED_MODULE_7__[/* default */ "a"])(_mixins_binds_attrs__WEBPACK_IMPORTED_MODULE_1__[/* default */ "a"], _mixins_colorable__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], _mixins_sizeable__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"], _mixins_themeable__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"]
/* @vue/component */).extend({
  name: 'v-icon',
  props: {
    dense: Boolean,
    disabled: Boolean,
    left: Boolean,
    right: Boolean,
    size: [Number, String],
    tag: {
      type: String,
      required: false,
      default: 'i'
    }
  },
  computed: {
    medium() {
      return false;
    },
    hasClickListener() {
      return Boolean(this.listeners$.click || this.listeners$['!click']);
    }
  },
  methods: {
    getIcon() {
      let iconName = '';
      if (this.$slots.default) iconName = this.$slots.default[0].text.trim();
      return Object(_util_helpers__WEBPACK_IMPORTED_MODULE_5__[/* remapInternalIcon */ "w"])(this, iconName);
    },
    getSize() {
      const sizes = {
        xSmall: this.xSmall,
        small: this.small,
        medium: this.medium,
        large: this.large,
        xLarge: this.xLarge
      };
      const explicitSize = Object(_util_helpers__WEBPACK_IMPORTED_MODULE_5__[/* keys */ "t"])(sizes).find(key => sizes[key]);
      return explicitSize && SIZE_MAP[explicitSize] || Object(_util_helpers__WEBPACK_IMPORTED_MODULE_5__[/* convertToUnit */ "g"])(this.size);
    },
    // Component data for both font icon and SVG wrapper span
    getDefaultData() {
      return {
        staticClass: 'v-icon notranslate',
        class: {
          'v-icon--disabled': this.disabled,
          'v-icon--left': this.left,
          'v-icon--link': this.hasClickListener,
          'v-icon--right': this.right,
          'v-icon--dense': this.dense
        },
        attrs: {
          'aria-hidden': !this.hasClickListener,
          disabled: this.hasClickListener && this.disabled,
          type: this.hasClickListener ? 'button' : undefined,
          ...this.attrs$
        },
        on: this.listeners$
      };
    },
    getSvgWrapperData() {
      const fontSize = this.getSize();
      const wrapperData = {
        ...this.getDefaultData(),
        style: fontSize ? {
          fontSize,
          height: fontSize,
          width: fontSize
        } : undefined
      };
      this.applyColors(wrapperData);
      return wrapperData;
    },
    applyColors(data) {
      data.class = {
        ...data.class,
        ...this.themeClasses
      };
      this.setTextColor(this.color, data);
    },
    renderFontIcon(icon, h) {
      const newChildren = [];
      const data = this.getDefaultData();
      let iconType = 'material-icons'; // Material Icon delimiter is _
      // https://material.io/icons/

      const delimiterIndex = icon.indexOf('-');
      const isMaterialIcon = delimiterIndex <= -1;
      if (isMaterialIcon) {
        // Material icon uses ligatures.
        newChildren.push(icon);
      } else {
        iconType = icon.slice(0, delimiterIndex);
        if (isFontAwesome5(iconType)) iconType = '';
      }
      data.class[iconType] = true;
      data.class[icon] = !isMaterialIcon;
      const fontSize = this.getSize();
      if (fontSize) data.style = {
        fontSize
      };
      this.applyColors(data);
      return h(this.hasClickListener ? 'button' : this.tag, data, newChildren);
    },
    renderSvgIcon(icon, h) {
      const svgData = {
        class: 'v-icon__svg',
        attrs: {
          xmlns: 'http://www.w3.org/2000/svg',
          viewBox: '0 0 24 24',
          role: 'img',
          'aria-hidden': true
        }
      };
      const size = this.getSize();
      if (size) {
        svgData.style = {
          fontSize: size,
          height: size,
          width: size
        };
      }
      return h(this.hasClickListener ? 'button' : 'span', this.getSvgWrapperData(), [h('svg', svgData, [h('path', {
        attrs: {
          d: icon
        }
      })])]);
    },
    renderSvgIconComponent(icon, h) {
      const data = {
        class: {
          'v-icon__component': true
        }
      };
      const size = this.getSize();
      if (size) {
        data.style = {
          fontSize: size,
          height: size,
          width: size
        };
      }
      this.applyColors(data);
      const component = icon.component;
      data.props = icon.props;
      data.nativeOn = data.on;
      return h(this.hasClickListener ? 'button' : 'span', this.getSvgWrapperData(), [h(component, data)]);
    }
  },
  render(h) {
    const icon = this.getIcon();
    if (typeof icon === 'string') {
      if (isSvgPath(icon)) {
        return this.renderSvgIcon(icon, h);
      }
      return this.renderFontIcon(icon, h);
    }
    return this.renderSvgIconComponent(icon, h);
  }
});
/* harmony default export */ __webpack_exports__["a"] = (vue__WEBPACK_IMPORTED_MODULE_6___default.a.extend({
  name: 'v-icon',
  $_wrapperFor: VIcon,
  functional: true,
  render(h, {
    data,
    children
  }) {
    let iconName = ''; // Support usage of v-text and v-html

    if (data.domProps) {
      iconName = data.domProps.textContent || data.domProps.innerHTML || iconName; // Remove nodes so it doesn't
      // overwrite our changes

      delete data.domProps.textContent;
      delete data.domProps.innerHTML;
    }
    return h(VIcon, data, iconName ? [iconName] : children);
  }
}));

/***/ }),

/***/ 116:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 151:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 152:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 154:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "img/compatiable.2fb1964.svg";

/***/ }),

/***/ 155:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "img/compatiable-not.12dbbc5.svg";

/***/ }),

/***/ 196:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VBtn/VBtn.js
var VBtn = __webpack_require__(101);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/VCard.js
var VCard = __webpack_require__(97);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VCard/index.js
var components_VCard = __webpack_require__(95);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VCol.js
var VCol = __webpack_require__(110);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VIcon/VIcon.js
var VIcon = __webpack_require__(113);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VImg/VImg.js + 2 modules
var VImg = __webpack_require__(100);

// EXTERNAL MODULE: ./node_modules/vuetify/lib/components/VGrid/VRow.js
var VRow = __webpack_require__(109);

// CONCATENATED MODULE: ./node_modules/vuetify-loader/lib/loader.js??ref--4!./node_modules/babel-loader/lib??ref--2-0!./node_modules/vue-loader/lib/loaders/templateLoader.js??ref--7!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/ProductsCard.vue?vue&type=template&id=39e0b781&scoped=true








var ProductsCardvue_type_template_id_39e0b781_scoped_true_render = function render() {
  var _vm$products;
  var _vm = this,
    _c = _vm._self._c;
  return _c(VCard["a" /* default */], {
    staticClass: "newSlider elevation-0 px-md-2",
    attrs: {
      "tile": "",
      "color": "transparent"
    }
  }, [(_vm$products = _vm.products) !== null && _vm$products !== void 0 && _vm$products.length ? _c('VueSlickCarousel', _vm._b({
    ref: "carousel"
  }, 'VueSlickCarousel', _vm.productSettings, false), _vm._l(_vm.filteredProducts, function (product, index) {
    return _c(VCard["a" /* default */], {
      key: index,
      staticClass: "cardWidth",
      class: {
        ' elevation-4 ': _vm.hoverIndex === index,
        'elevation-0 ': _vm.hoverIndex !== index
      },
      attrs: {
        "tile": "",
        "color": "transparent",
        "height": "320"
      },
      on: {
        "click": function ($event) {
          return _vm.viewDetails(product);
        },
        "mouseenter": function ($event) {
          return _vm.addElevation(index);
        },
        "mouseleave": function ($event) {
          return _vm.removeElevation(index);
        }
      }
    }, [_c('div', {
      staticClass: "grey lighten-2",
      staticStyle: {
        "background-color": "#E0E0E0",
        "height": "149px"
      }
    }, [product.images ? _c(VImg["a" /* default */], {
      staticClass: "cursor_pointer",
      attrs: {
        "alt": "Description of the image",
        "width": "100%",
        "height": "125",
        "src": 'https://newshop.testshop1.bimmer-tech.net' + product.images
      }
    }, [_c('div', {
      staticClass: "compatibility_img2"
    }, [_c('div', [product.compatibility == 'Yes' || product.compatibility == 'Compatible' ? _c('span', {
      staticClass: "cui bt-svg-icon"
    }, [_c('img', {
      staticClass: "off_price2",
      attrs: {
        "src": __webpack_require__(154)
      }
    })]) : _vm._e(), _vm._v(" "), product.compatibility == 'No' || product.compatibility == 'Not compatible' ? _c('span', {
      staticClass: "cui bt-svg-icon"
    }, [_c('img', {
      attrs: {
        "src": __webpack_require__(155)
      }
    })]) : _vm._e()])]), _vm._v(" "), product.bestseller ? _c('div', [product.bestseller.name ? _c('div', {
      staticClass: "center-content"
    }, [_c('p', {
      staticClass: "text-10 FF_Manrope mb-0 white--text",
      staticStyle: {
        "line-height": "10px !important"
      },
      domProps: {
        "innerHTML": _vm._s(product.bestseller.name)
      }
    })]) : _vm._e()]) : _vm._e(), _vm._v(" "), (product === null || product === void 0 ? void 0 : product.originalPrice) > (product === null || product === void 0 ? void 0 : product.price) ? _c('span', {
      staticClass: "discount_price text-14 primary white--text FF_Manrope px-4"
    }, [_vm._v("\n           $" + _vm._s((((product === null || product === void 0 ? void 0 : product.originalPrice) - (product === null || product === void 0 ? void 0 : product.price)) / 100).toFixed(2)) + " off\n          ")]) : _vm._e()]) : _vm._e()], 1), _vm._v(" "), _c(components_VCard["c" /* VCardText */], {
      staticClass: "px-2"
    }, [_c(VRow["a" /* default */], {
      staticClass: "mx-0"
    }, [_vm._l(product.brands, function (brandname) {
      return _c(VBtn["a" /* default */], {
        staticClass: "bmw mr-1 bgwhite",
        attrs: {
          "elevation": "0",
          "outlined": "",
          "x-small": "",
          "tile": ""
        }
      }, [_vm._v("\n          " + _vm._s(brandname.name) + " \n        ")]);
    }), _vm._v(" "), _c('div', {
      staticClass: "grey--text"
    }, [_c('span', {
      staticClass: "ml-2 review-count"
    }, [_vm._v(_vm._s(product.reviewCount) + " ")]), _vm._v(" "), _c(VIcon["a" /* default */], {
      attrs: {
        "color": "orange",
        "small": ""
      }
    }, [_vm._v("mdi-star")])], 1)], 2), _vm._v(" "), _c('p', {
      staticClass: "text-16 FF_Manrope mt-4 pl-0 pr-2 black1--text cr-product-name",
      staticStyle: {
        "font-weight": "500"
      }
    }, [_vm._v(" " + _vm._s(product.name))])], 1), _vm._v(" "), _c(components_VCard["c" /* VCardText */], {
      staticClass: "bottomBtn"
    }, [_c(VRow["a" /* default */], [_c(VCol["a" /* default */], {
      staticClass: "px-0 align-content-end btnpwrap custom",
      staticStyle: {
        "min-height": "60px",
        "white-space": "nowrap",
        "overflow": "hidden",
        "text-overflow": "ellipsis"
      },
      attrs: {
        "cols": "12",
        "lg": "6",
        "sm": "6"
      }
    }, [_c('div', {
      staticClass: "d-flex"
    }, [_c('p', {
      staticClass: "text-14 FF_Manrope pa-0 ma-0 black1--text"
    }, [_vm._v("\n              from\n         ")]), _vm._v(" "), product.originalPrice > product.price ? _c('p', {
      staticClass: "pa-0 pl-1 ma-0 text-14 font-weight-normal FF_Manrope",
      staticStyle: {
        "opacity": "0.5"
      }
    }, [_c('del', [_vm._v("$" + _vm._s((product.originalPrice / 100).toFixed(2)))])]) : _vm._e()]), _vm._v(" "), _c('p', {
      staticClass: "cr-product-price FF_Manrope secondary--text font-weight-bold pa-0 ma-0",
      class: product.originalPrice > product.price || product.isContainer ? 'mt-1' : 'mt-2',
      staticStyle: {
        "font-size": "20px",
        "font-weight": "700 !important"
      }
    }, [_vm._v(" $" + _vm._s((product.price / 100).toFixed(2)) + "\n        ")])]), _vm._v(" "), _c(VCol["a" /* default */], {
      staticClass: "pl-0 align-content-end custom",
      attrs: {
        "cols": "12",
        "lg": "6",
        "sm": "6"
      }
    }, [_c('div', {
      staticClass: "text-12 d-flex align-end justify-end FF_Manrope font-weight-regular text-right",
      staticStyle: {
        "color": "#949494"
      }
    }, [_c('span', [_vm._v(" Free shipping ")])])])], 1)], 1)], 1);
  }), 1) : _vm._e()], 1);
};
var staticRenderFns = [];

// CONCATENATED MODULE: ./components/ProductsCard.vue?vue&type=template&id=39e0b781&scoped=true

// EXTERNAL MODULE: external "vuex"
var external_vuex_ = __webpack_require__(9);

// EXTERNAL MODULE: external "vue-slick-carousel"
var external_vue_slick_carousel_ = __webpack_require__(99);
var external_vue_slick_carousel_default = /*#__PURE__*/__webpack_require__.n(external_vue_slick_carousel_);

// EXTERNAL MODULE: ./node_modules/vue-slick-carousel/dist/vue-slick-carousel.css
var vue_slick_carousel = __webpack_require__(151);

// EXTERNAL MODULE: ./node_modules/vue-slick-carousel/dist/vue-slick-carousel-theme.css
var vue_slick_carousel_theme = __webpack_require__(152);

// CONCATENATED MODULE: ./node_modules/babel-loader/lib??ref--2-0!./node_modules/@nuxt/components/dist/loader.js??ref--0-0!./node_modules/vue-loader/lib??vue-loader-options!./components/ProductsCard.vue?vue&type=script&lang=js




/* harmony default export */ var ProductsCardvue_type_script_lang_js = ({
  props: ['productSettings'],
  components: {
    VueSlickCarousel: external_vue_slick_carousel_default.a
  },
  data() {
    return {
      selectedBrand: 0,
      rating: 5,
      elevation: false,
      hoverIndex: '',
      difference: 0,
      settings: {
        arrows: false,
        dots: false,
        infinite: true,
        speed: 300,
        slidesToShow: 5,
        slidesToScroll: 1,
        autoplaySpeed: 3000,
        autoplay: false,
        useCSS: true,
        responsive: [{
          breakpoint: 1024,
          settings: {
            slidesToShow: 3,
            slidesToScroll: 3,
            infinite: true,
            dots: false
          }
        }, {
          breakpoint: 600,
          settings: {
            slidesToShow: 1.5,
            slidesToScroll: 1,
            initialSlide: 1,
            dots: false
          }
        }]
      },
      products: []
    };
  },
  methods: {
    ...Object(external_vuex_["mapActions"])(["get_home_products"]),
    getHomeProducts() {
      this.get_home_products().then(response => {
        var _this$product, _this$product2;
        this.products = response.data;
        this.difference = ((_this$product = this.product) === null || _this$product === void 0 ? void 0 : _this$product.originalPrice) - ((_this$product2 = this.product) === null || _this$product2 === void 0 ? void 0 : _this$product2.price);
      }).catch(error => {
        console.log("error");
      });
    },
    addElevation(index) {
      this.hoverIndex = index;
    },
    removeElevation() {
      this.hoverIndex = '';
    },
    viewDetails(product) {
      if (false) {}
      this.$router.push({
        path: product.url
      });
    },
    showDiscount() {
      var _this$product3, _this$product4;
      this.difference = ((_this$product3 = this.product) === null || _this$product3 === void 0 ? void 0 : _this$product3.originalPrice) - ((_this$product4 = this.product) === null || _this$product4 === void 0 ? void 0 : _this$product4.price);
      return difference;
    }
  },
  computed: {
    filteredProducts() {
      console.log('filteringBrand', this.selectedBrand);
      if (this.selectedBrand == 1) {
        return this.products.filter(product => product.brands.some(brand => brand.name === this.selectedBrand));
      } else {
        return this.products;
      }
    }
  },
  mounted() {
    this.getHomeProducts();
    this.$nuxt.$on("vinAdded", payload => {
      this.getHomeProducts();
    });
    this.$nuxt.$on("toggleBMWTesla", payload => {
      setTimeout(() => {
        console.log(this.$refs.carousel.$el);
        this.$refs.carousel.$el.slick('unslick');
        this.$refs.carousel.$el.slick('unslick');
      }, 2000); // 2000 milliseconds = 2 seconds

      // this.$refs.slickCarousel.destroy();
      if (payload === 1) {
        this.selectedBrand = "Tesla";
      } else {
        this.selectedBrand = "BMW";
      }
    });
  }
});
// CONCATENATED MODULE: ./components/ProductsCard.vue?vue&type=script&lang=js
 /* harmony default export */ var components_ProductsCardvue_type_script_lang_js = (ProductsCardvue_type_script_lang_js); 
// EXTERNAL MODULE: ./node_modules/vue-loader/lib/runtime/componentNormalizer.js
var componentNormalizer = __webpack_require__(21);

// CONCATENATED MODULE: ./components/ProductsCard.vue



function injectStyles (context) {
  
  var style0 = __webpack_require__(277)
if (style0.__inject__) style0.__inject__(context)
var style1 = __webpack_require__(278)
if (style1.__inject__) style1.__inject__(context)

}

/* normalize component */

var component = Object(componentNormalizer["a" /* default */])(
  components_ProductsCardvue_type_script_lang_js,
  ProductsCardvue_type_template_id_39e0b781_scoped_true_render,
  staticRenderFns,
  false,
  injectStyles,
  "39e0b781",
  "32f74754"
  
)

/* harmony default export */ var ProductsCard = __webpack_exports__["default"] = (component.exports);

/***/ }),

/***/ 203:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 204:
/***/ (function(module, exports) {

// Exports
module.exports = {

};


/***/ }),

/***/ 277:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_0_id_39e0b781_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(203);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_0_id_39e0b781_prod_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_0_id_39e0b781_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_0_id_39e0b781_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_0_id_39e0b781_prod_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 278:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_1_id_39e0b781_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(204);
/* harmony import */ var _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_1_id_39e0b781_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_1_id_39e0b781_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__);
/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_1_id_39e0b781_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__) if(["default"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_css_loader_dist_cjs_js_ref_3_oneOf_1_0_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_postcss_loader_dist_cjs_js_ref_3_oneOf_1_1_node_modules_nuxt_components_dist_loader_js_ref_0_0_node_modules_vue_loader_lib_index_js_vue_loader_options_ProductsCard_vue_vue_type_style_index_1_id_39e0b781_prod_scoped_true_lang_css__WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));


/***/ }),

/***/ 95:
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return VCardActions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return VCardSubtitle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return VCardText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return VCardTitle; });
/* harmony import */ var _VCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(97);
/* harmony import */ var _util_helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2);


const VCardActions = Object(_util_helpers__WEBPACK_IMPORTED_MODULE_1__[/* createSimpleFunctional */ "i"])('v-card__actions');
const VCardSubtitle = Object(_util_helpers__WEBPACK_IMPORTED_MODULE_1__[/* createSimpleFunctional */ "i"])('v-card__subtitle');
const VCardText = Object(_util_helpers__WEBPACK_IMPORTED_MODULE_1__[/* createSimpleFunctional */ "i"])('v-card__text');
const VCardTitle = Object(_util_helpers__WEBPACK_IMPORTED_MODULE_1__[/* createSimpleFunctional */ "i"])('v-card__title');

/* unused harmony default export */ var _unused_webpack_default_export = ({
  $_vuetify_subcomponents: {
    VCard: _VCard__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"],
    VCardActions,
    VCardSubtitle,
    VCardText,
    VCardTitle
  }
});

/***/ })

};;
//# sourceMappingURL=products-card.js.map